/*
 * Decompiled with CFR 0.152.
 */
package com.taiping.common;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class Struts2Utils
implements Serializable {
    private static final long serialVersionUID = 8135767349279345254L;
    private static final String ENCODING_PREFIX = "encoding";
    private static final String NOCACHE_PREFIX = "no-cache";
    private static final String ENCODING_DEFAULT = "UTF-8";
    private static final boolean NOCACHE_DEFAULT = true;
    private static final String TEXT_TYPE = "text/plain";
    private static final String JSON_TYPE = "application/json";
    private static final String XML_TYPE = "text/xml";
    private static final String HTML_TYPE = "text/html";
    private static final String JS_TYPE = "text/javascript";

    public static HttpSession getSession() {
        return ServletActionContext.getRequest().getSession();
    }

    public static HttpServletRequest getRequest() {
        return ServletActionContext.getRequest();
    }

    public static HttpServletResponse getResponse() {
        return ServletActionContext.getResponse();
    }

    public static String getParameter(String name) {
        return Struts2Utils.getRequest().getParameter(name);
    }

    public static void render(String contentType, String content, String ... headers) {
        try {
            String encoding = ENCODING_DEFAULT;
            boolean noCache = true;
            for (String header : headers) {
                String headerName = StringUtils.substringBefore((String)header, (String)":");
                String headerValue = StringUtils.substringAfter((String)header, (String)":");
                if (StringUtils.equalsIgnoreCase((CharSequence)headerName, (CharSequence)ENCODING_PREFIX)) {
                    encoding = headerValue;
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)headerName, (CharSequence)NOCACHE_PREFIX)) {
                    noCache = Boolean.parseBoolean(headerValue);
                    continue;
                }
                throw new IllegalArgumentException(headerName + "\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684header\u7c7b\u578b");
            }
            HttpServletResponse response = ServletActionContext.getResponse();
            String fullContentType = contentType + ";charset=" + encoding;
            response.setContentType(fullContentType);
            if (noCache) {
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", NOCACHE_PREFIX);
                response.setDateHeader("Expires", 0L);
            }
            response.getWriter().write(content);
            response.getWriter().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void renderText(String text, String ... headers) {
        Struts2Utils.render(TEXT_TYPE, text, headers);
    }

    public static void renderHtml(String html, String ... headers) {
        Struts2Utils.render(HTML_TYPE, html, headers);
    }

    public static void renderXml(String xml, String ... headers) {
        Struts2Utils.render(XML_TYPE, xml, headers);
    }

    public static void renderJson(String jsonString, String ... headers) {
        Struts2Utils.render(JSON_TYPE, jsonString, headers);
    }

    public static void renderJson(Map map, String ... headers) {
        String jsonString = JSONObject.fromObject((Object)map).toString();
        Struts2Utils.render(JSON_TYPE, jsonString, headers);
    }

    public static void renderJson(Object object, String ... headers) {
        String jsonString = JSONObject.fromObject((Object)object).toString();
        Struts2Utils.render(JSON_TYPE, jsonString, headers);
    }

    public static void renderJson(Collection<?> collction, String ... headers) {
        String jsonString = JSONArray.fromObject(collction).toString();
        Struts2Utils.render(JSON_TYPE, jsonString, headers);
    }

    public static void renderJson(Object[] array, String ... headers) {
        String jsonString = JSONArray.fromObject((Object)array).toString();
        Struts2Utils.render(JSON_TYPE, jsonString, headers);
    }

    public static void renderJsonp(String callbackName, Map contentMap, String ... headers) {
        String jsonParam = JSONObject.fromObject((Object)contentMap).toString();
        StringBuilder result = new StringBuilder().append(callbackName).append("(").append(jsonParam).append(");");
        Struts2Utils.render(JS_TYPE, result.toString(), headers);
    }
}

