/*
 * Decompiled with CFR 0.152.
 */
package com.taiping.common;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XmlUtils {
    private static String elementResult = "";
    public static final String DEFAULT_ENCODING = "UTF-8";

    public static void createDocment(Document doc) {
    }

    private XmlUtils() {
    }

    public static Element child(Element element, String name) {
        return element.element(new QName(name, element.getNamespace()));
    }

    public static Element child(Element element, String name, boolean optional) throws Exception {
        Element child = element.element(new QName(name, element.getNamespace()));
        if (child == null && !optional) {
            throw new Exception(name + " element expected as child of " + element.getName() + ".");
        }
        return child;
    }

    public static List children(Element element, String name) {
        return element.elements(new QName(name, element.getNamespace()));
    }

    public static String getAttribute(Element element, String name, boolean optional) throws Exception {
        Attribute attr = null;
        if (element != null) {
            attr = element.attribute(name);
        }
        if (attr == null && !optional) {
            if (element != null) {
                throw new Exception("Attribute " + name + " of " + element.getName() + " expected.");
            }
            return null;
        }
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    public static String getAttributeAsString(Element element, String name, boolean optional) throws Exception {
        return XmlUtils.getAttribute(element, name, optional);
    }

    public static int getAttributeAsInt(Element element, String name, boolean optional) throws Exception {
        try {
            return Integer.parseInt(XmlUtils.getAttribute(element, name, optional));
        }
        catch (NumberFormatException exception) {
            throw new Exception(element.getName() + "/@" + name + " attribute: value format error.", exception);
        }
    }

    public static int getAttributeAsInt(Element element, String name, int defaultValue, boolean optional) throws Exception {
        String value = XmlUtils.getAttribute(element, name, optional);
        if (optional && (value == null || value.equals(""))) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException exception) {
            throw new Exception(element.getName() + "/@" + name + " attribute: value format error.", exception);
        }
    }

    public static float getAttributeAsFloat(Element element, String name, boolean optional) throws Exception {
        try {
            return Float.parseFloat(XmlUtils.getAttribute(element, name, optional));
        }
        catch (NumberFormatException exception) {
            throw new Exception(element.getName() + "/@" + name + " attribute: value format error.", exception);
        }
    }

    public static float getAttributeAsFloat(Element element, String name, float defaultValue, boolean optional) throws Exception {
        String value = XmlUtils.getAttribute(element, name, optional);
        if (optional && (value == null || value.equals(""))) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException exception) {
            throw new Exception(element.getName() + "/@" + name + " attribute: value format error.", exception);
        }
    }

    public static long getAttributeAsLong(Element element, String name, boolean optional) throws Exception {
        try {
            return Long.parseLong(XmlUtils.getAttribute(element, name, optional));
        }
        catch (NumberFormatException exception) {
            throw new Exception(element.getName() + "/@" + name + " attribute: value format error.", exception);
        }
    }

    public static long getAttributeAsLong(Element element, String name, long defaultValue, boolean optional) throws Exception {
        String value = XmlUtils.getAttribute(element, name, optional);
        if (optional && (value == null || value.equals(""))) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException exception) {
            throw new Exception(element.getName() + "/@" + name + " attribute: value format error.", exception);
        }
    }

    public static Element getFirstChild(Element element, String name, boolean optional) throws Exception {
        List list = element.elements(new QName(name, element.getNamespace()));
        if (list.size() > 0) {
            return (Element)list.get(0);
        }
        if (!optional) {
            throw new Exception(name + " element expected as first child of " + element.getName() + ".");
        }
        return null;
    }

    public static Element getSibling(Element element, boolean optional) throws Exception {
        return XmlUtils.getSibling(element, element.getName(), optional);
    }

    public static Element getSibling(Element element, String name, boolean optional) throws Exception {
        List list = element.getParent().elements(name);
        if (list.size() > 0) {
            return (Element)list.get(0);
        }
        if (!optional) {
            throw new Exception(name + " element expected after " + element.getName() + ".");
        }
        return null;
    }

    public static String getContent(Element element, boolean optional) throws Exception {
        String content = null;
        if (element != null) {
            content = element.getText();
        }
        if (content == null && !optional) {
            if (element != null) {
                throw new Exception(element.getName() + " element: content expected.");
            }
            return null;
        }
        return content;
    }

    public static String getContentAsString(Element element, boolean optional) throws Exception {
        return XmlUtils.getContent(element, optional);
    }

    public static int getContentAsInt(Element element, boolean optional) throws Exception {
        try {
            return Integer.parseInt(XmlUtils.getContent(element, optional));
        }
        catch (NumberFormatException exception) {
            throw new Exception(element.getName() + " element: content format error.", exception);
        }
    }

    public static int getContentAsInt(Element element, int defaultValue, boolean optional) throws Exception {
        String value = XmlUtils.getContent(element, optional);
        if (optional && (value == null || value.equals(""))) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException exception) {
            throw new Exception(element.getName() + " element: content format error.", exception);
        }
    }

    public static long getContentAsLong(Element element, boolean optional) throws Exception {
        try {
            return Long.parseLong(XmlUtils.getContent(element, optional));
        }
        catch (NumberFormatException exception) {
            throw new Exception(element.getName() + " element: content format error.", exception);
        }
    }

    public static long getContentAsLong(Element element, long defaultValue, boolean optional) throws Exception {
        String value = XmlUtils.getContent(element, optional);
        if (optional && (value == null || value.equals(""))) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException exception) {
            throw new Exception(element.getName() + " element: content format error.", exception);
        }
    }

    public static float getContentAsFloat(Element element, boolean optional) throws Exception {
        try {
            return Float.parseFloat(XmlUtils.getContent(element, optional));
        }
        catch (NumberFormatException exception) {
            throw new Exception(element.getName() + " element: content format error.", exception);
        }
    }

    public static float getContentAsFloat(Element element, float defaultValue, boolean optional) throws Exception {
        String value = XmlUtils.getContent(element, optional);
        if (optional && (value == null || value.equals(""))) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException exception) {
            throw new Exception(element.getName() + " element: content format error.", exception);
        }
    }

    public static String getSubTagValue(Element root, String subTagName) {
        String returnString = root.elementText(subTagName);
        return returnString;
    }

    public static String getSubTagValue(Element root, String tagName, String subTagName) {
        Element child = root.element(tagName);
        String returnString = child.elementText(subTagName);
        return returnString;
    }

    public static Element appendChild(Element parent, String name, String value) {
        Element element = parent.addElement(new QName(name, parent.getNamespace()));
        if (value != null) {
            element.addText(value);
        }
        return element;
    }

    public static Element appendChild(Element parent, String name) {
        return parent.addElement(new QName(name, parent.getNamespace()));
    }

    public static Element appendChild(Element parent, String name, int value) {
        return XmlUtils.appendChild(parent, name, String.valueOf(value));
    }

    public static Element appendChild(Element parent, String name, long value) {
        return XmlUtils.appendChild(parent, name, String.valueOf(value));
    }

    public static Element appendChild(Element parent, String name, float value) {
        return XmlUtils.appendChild(parent, name, String.valueOf(value));
    }

    public static boolean checkDocumentType(Document document, String dtdPublicId) {
        DocumentType documentType = document.getDocType();
        if (documentType != null) {
            String publicId = documentType.getPublicID();
            return publicId != null && publicId.equals(dtdPublicId);
        }
        return true;
    }

    public static Document createDocument() throws Exception {
        DocumentFactory factory = new DocumentFactory();
        Document document = factory.createDocument();
        return document;
    }

    public static Document fromXML(Reader in, String encoding) throws Exception {
        try {
            if (encoding == null || encoding.equals("")) {
                encoding = DEFAULT_ENCODING;
            }
            SAXReader reader = new SAXReader();
            Document document = reader.read(in, encoding);
            return document;
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    public static Document fromXML(InputStream inputSource, String encoding) throws Exception {
        try {
            if (encoding == null || encoding.equals("")) {
                encoding = DEFAULT_ENCODING;
            }
            SAXReader reader = new SAXReader();
            Document document = reader.read(inputSource, encoding);
            return document;
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    public static Document fromXML(String source, String encoding) throws Exception {
        return XmlUtils.fromXML(new StringReader(source), encoding);
    }

    public static void toXML(Document document, Writer outWriter, String encoding) throws Exception {
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        if (encoding == null || encoding.trim().equals("")) {
            encoding = DEFAULT_ENCODING;
        }
        outformat.setEncoding(encoding);
        XMLWriter xmlWriter = null;
        try {
            xmlWriter = new XMLWriter(outWriter, outformat);
            xmlWriter.write(document);
            xmlWriter.flush();
        }
        catch (IOException ex) {
            throw new Exception(ex);
        }
        finally {
            if (xmlWriter != null) {
                try {
                    xmlWriter.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static void toXML(Document document, OutputStream outStream, String encoding) throws Exception {
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        if (encoding == null || encoding.trim().equals("")) {
            encoding = DEFAULT_ENCODING;
        }
        outformat.setEncoding(encoding);
        XMLWriter xmlWriter = null;
        try {
            xmlWriter = new XMLWriter(outStream, outformat);
            xmlWriter.write(document);
            xmlWriter.flush();
        }
        catch (IOException ex) {
            throw new Exception(ex);
        }
        finally {
            if (xmlWriter != null) {
                try {
                    xmlWriter.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static String toXML(Document document, String encoding) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        XmlUtils.toXML(document, stream, encoding);
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return stream.toString();
    }

    public static void setElementValueByElementName(Element ElementName, String StrElement, String Value) throws Exception {
        Iterator someElementIterator = ElementName.elementIterator();
        while (someElementIterator.hasNext()) {
            Element elem = (Element)someElementIterator.next();
            if (StrElement.equals(elem.getName())) {
                elem.setText(Value);
                break;
            }
            XmlUtils.setElementValueByElementName(elem, StrElement, Value);
        }
    }

    public static String getElementValueByElementName(Element ElementName, String StrElement) throws Exception {
        elementResult = "";
        Iterator someElementIterator = ElementName.elementIterator();
        while (someElementIterator.hasNext()) {
            Element elem = (Element)someElementIterator.next();
            if (StrElement.equals(elem.getName())) {
                elementResult = elem.getText();
                break;
            }
            XmlUtils.getElementValueByElementName(elem, StrElement);
        }
        return elementResult;
    }

    public static String objectToXML(Object obj) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        String xml = xstream.toXML(obj);
        return xml;
    }

    public static Object xmlToObject(String xmlStr) throws Exception {
        XStream xs = new XStream((HierarchicalStreamDriver)new DomDriver());
        Object ob = xs.fromXML(xmlStr);
        return ob;
    }
}

