/*
 * Decompiled with CFR 0.152.
 */
package com.taiping.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class ZipUtils {
    public static void zip(String zipFileName, String relativePath, String directory) throws FileNotFoundException, IOException {
        String fileName = zipFileName;
        if (fileName == null || fileName.trim().equals("")) {
            File temp = new File(directory);
            fileName = temp.isDirectory() ? directory + ".zip" : (directory.indexOf(".") > 0 ? directory.substring(0, directory.lastIndexOf(".")) + "zip" : directory + ".zip");
        }
        ZipOutputStream zos = new ZipOutputStream((OutputStream)new FileOutputStream(fileName));
        try {
            ZipUtils.zip(zos, relativePath, directory);
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (null != zos) {
                zos.close();
            }
        }
    }

    private static void zip(ZipOutputStream zos, String relativePath, String absolutPath) throws IOException {
        File file = new File(absolutPath);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File tempFile = files[i];
                if (tempFile.isDirectory()) {
                    String newRelativePath = relativePath + tempFile.getName() + File.separator;
                    ZipUtils.createZipNode(zos, newRelativePath);
                    ZipUtils.zip(zos, newRelativePath, tempFile.getPath());
                    continue;
                }
                ZipUtils.zipFile(zos, tempFile, relativePath);
            }
        } else {
            ZipUtils.zipFile(zos, file, relativePath);
        }
    }

    private static void zipFile(ZipOutputStream zos, File file, String relativePath) throws IOException {
        ZipEntry entry = new ZipEntry(relativePath + file.getName());
        zos.putNextEntry(entry);
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            int BUFFERSIZE = 2048;
            int length = 0;
            byte[] buffer = new byte[BUFFERSIZE];
            while ((length = ((InputStream)is).read(buffer, 0, BUFFERSIZE)) >= 0) {
                zos.write(buffer, 0, length);
            }
            zos.flush();
            zos.closeEntry();
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (null != is) {
                ((InputStream)is).close();
            }
        }
    }

    private static void createZipNode(ZipOutputStream zos, String relativePath) throws IOException {
        ZipEntry zipEntry = new ZipEntry(relativePath);
        zos.putNextEntry(zipEntry);
        zos.closeEntry();
    }

    public static void unzip(String zipFilePath, String targetPath) throws IOException {
        OutputStream os = null;
        InputStream is = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zipFilePath);
            String directoryPath = "";
            directoryPath = null == targetPath || "".equals(targetPath) ? zipFilePath.substring(0, zipFilePath.lastIndexOf(".")) : targetPath;
            Enumeration entryEnum = zipFile.getEntries();
            if (null != entryEnum) {
                ZipEntry zipEntry = null;
                while (entryEnum.hasMoreElements()) {
                    String directoryNewPath = "";
                    zipEntry = (ZipEntry)entryEnum.nextElement();
                    if (zipEntry.isDirectory()) {
                        directoryNewPath = directoryPath + File.separator + zipEntry.getName();
                        System.out.println(directoryNewPath);
                        continue;
                    }
                    if (zipEntry.getSize() > 0L) {
                        File targetFile = ZipUtils.buildFile(directoryPath + File.separator + zipEntry.getName(), false);
                        os = new BufferedOutputStream(new FileOutputStream(targetFile));
                        is = zipFile.getInputStream(zipEntry);
                        byte[] buffer = new byte[4096];
                        int readLen = 0;
                        while ((readLen = is.read(buffer, 0, 4096)) >= 0) {
                            os.write(buffer, 0, readLen);
                        }
                        os.flush();
                        os.close();
                        continue;
                    }
                    ZipUtils.buildFile(directoryPath + File.separator + zipEntry.getName(), true);
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (null != zipFile) {
                zipFile = null;
            }
            if (null != is) {
                is.close();
            }
            if (null != os) {
                os.close();
            }
        }
    }

    public static void newUnZip(String fileName, String filePath) throws Exception {
        filePath = filePath + File.separator;
        ZipFile zipFile = new ZipFile(fileName);
        Enumeration emu = zipFile.getEntries();
        while (emu.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)emu.nextElement();
            if (entry.isDirectory()) {
                new File(filePath + entry.getName()).mkdirs();
                continue;
            }
            BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
            File file = new File(filePath + entry.getName());
            File parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream bos = new BufferedOutputStream(fos, 1024);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = bis.read(buf, 0, 1024)) != -1) {
                fos.write(buf, 0, len);
            }
            bos.flush();
            bos.close();
            bis.close();
            System.out.println("\u89e3\u538b\u6587\u4ef6\uff1a" + file.getName());
        }
        zipFile.close();
    }

    public static File buildFile(String fileName, boolean isDirectory) {
        File target = new File(fileName);
        if (isDirectory) {
            target.mkdirs();
        } else if (!target.getParentFile().exists()) {
            target.getParentFile().mkdirs();
            target = new File(target.getAbsolutePath());
        }
        return target;
    }
}

