/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.statuscheck;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.client.statuscheck.ResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginStatusCheckFilter
implements Filter {
    public static final String ALREADY_FILTERED_SUFFIX = "LoginStatusCheckFilter.FILTERED";
    private String casServerLoginUrl;
    private String serverName;
    private String defaultClientUrl;
    private String autoCheckLoginStatusUrlPrefix;
    private String autoCheckLoginFlag = "true";
    private Logger logger = LoggerFactory.getLogger(LoginStatusCheckFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        this.casServerLoginUrl = filterConfig.getInitParameter("casServerLoginUrl");
        this.serverName = filterConfig.getInitParameter("serverName");
        this.defaultClientUrl = filterConfig.getInitParameter("defaultClientUrl");
        this.autoCheckLoginStatusUrlPrefix = filterConfig.getInitParameter("autoCheckLoginStatusUrlPrefix");
        if (filterConfig.getInitParameter("autoCheckLoginFlag") != null) {
            this.autoCheckLoginFlag = filterConfig.getInitParameter("autoCheckLoginFlag");
        }
        if (this.casServerLoginUrl == null || "".equals(this.casServerLoginUrl.trim())) {
            throw new RuntimeException("cas \u670d\u52a1\u524d\u7f00\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.casServerLoginUrl == null || "".equals(this.casServerLoginUrl.trim())) {
            throw new RuntimeException("\u9ed8\u8ba4\u5ba2\u6237\u670d\u52a1\u9000\u51fa\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        boolean hasAlreadyFilteredAttribute;
        if (servletRequest.getAttribute("__pass_sso") != null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        boolean bl = hasAlreadyFilteredAttribute = request.getAttribute(ALREADY_FILTERED_SUFFIX) != null;
        if (!hasAlreadyFilteredAttribute) {
            if (request.getRequestURI().endsWith("_client_version")) {
                response.setContentType("text/html");
                InputStream inputStream = null;
                try {
                    inputStream = LoginStatusCheckFilter.class.getResourceAsStream("/META-INF/maven/taiping.sso.client/cas-client-core/pom.properties");
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    byte[] data = new byte[4096];
                    int count = -1;
                    while ((count = inputStream.read(data, 0, 4096)) != -1) {
                        outStream.write(data, 0, count);
                    }
                    response.getWriter().write(new String(data));
                    data = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                return;
            }
            request.setAttribute(ALREADY_FILTERED_SUFFIX, (Object)Boolean.TRUE);
            try {
                Boolean cookLoginFlag = false;
                Cookie[] cookies = request.getCookies();
                if (cookies != null) {
                    for (Cookie cookie : cookies) {
                        if (!"__l".equals(cookie.getName()) || !"true".equals(cookie.getValue())) continue;
                        cookLoginFlag = true;
                        break;
                    }
                }
                Boolean sessionLoginFlag = false;
                Boolean cookieUuidFlag = false;
                String uuid = null;
                String cookieUid = null;
                if (request.getAttribute("_const_cas_assertion_") != null || request.getSession() != null && request.getSession().getAttribute("_const_cas_assertion_") != null) {
                    sessionLoginFlag = true;
                    uuid = (String)request.getSession().getAttribute("principaluuid");
                    if (request.getCookies() != null && uuid != null && !"".equals(uuid)) {
                        for (Cookie cookie : request.getCookies()) {
                            if (!"__u".equals(cookie.getName())) continue;
                            cookieUid = cookie.getValue();
                            break;
                        }
                    }
                }
                if (uuid == null || "".equals(uuid) || cookieUid == null || "".equals(cookieUid) || cookieUid.equals(uuid)) {
                    cookieUuidFlag = true;
                }
                this.logger.info("cookieUuidFlag:{}", (Object)cookieUuidFlag);
                if (!(cookieUuidFlag.booleanValue() && cookLoginFlag.booleanValue() || !sessionLoginFlag.booleanValue())) {
                    request.getSession().invalidate();
                }
                if (request.getRequestURI().endsWith("_checkStatus.js")) {
                    if (!sessionLoginFlag.booleanValue() && cookLoginFlag.booleanValue()) {
                        response.setContentType("application/javascript");
                        response.getWriter().write(this.getLoginImgStr(this.autoCheckLoginStatusUrlPrefix + "/_autologin_/a.jpg"));
                    } else if (!(cookLoginFlag.booleanValue() && cookieUuidFlag.booleanValue() || !sessionLoginFlag.booleanValue())) {
                        response.setContentType("application/javascript");
                        if (!cookLoginFlag.booleanValue()) {
                            request.getSession().invalidate();
                            response.getWriter().write("");
                        } else if (!cookieUuidFlag.booleanValue()) {
                            request.getSession().invalidate();
                            response.getWriter().write(this.getLoginImgStr(this.autoCheckLoginStatusUrlPrefix + "/_autologin_/a.jpg"));
                        }
                    } else {
                        response.setContentType("application/javascript");
                        response.getWriter().write("");
                    }
                    return;
                }
                if ("GET".equals(request.getMethod()) && "true".equals(request.getParameter("logout"))) {
                    if (request.getSession(false) != null) {
                        request.getSession(false).invalidate();
                    }
                    return;
                }
                if (request.getRequestURI().toLowerCase().endsWith("/logout")) {
                    String loginOutCallBackUrl;
                    request.getSession().invalidate();
                    String service = request.getParameter("service");
                    String string = service = service == null || "".equals(service) ? request.getHeader("Referer") : service;
                    if (service == null) {
                        service = this.defaultClientUrl;
                    }
                    if ((loginOutCallBackUrl = this.makeLogoutUrl(service, request, response)) == null || "".equals(loginOutCallBackUrl.trim())) {
                        response.sendRedirect(this.casServerLoginUrl + "/logout?service=" + URLEncoder.encode(service));
                    } else {
                        response.sendRedirect(this.casServerLoginUrl + "/logout?service=" + URLEncoder.encode(loginOutCallBackUrl) + "&redirect=true");
                    }
                    return;
                }
                if (request.getHeader("Accept") != null && request.getHeader("Accept").toLowerCase().indexOf("text/html") < 0) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                if (!cookieUuidFlag.booleanValue() && request.getUserPrincipal() != null && "GET".equals(request.getMethod())) {
                    request.getSession().invalidate();
                    this.serverLogin(request, response);
                    return;
                }
                if (sessionLoginFlag != false && cookLoginFlag != false && cookieUuidFlag != false || sessionLoginFlag == false && cookLoginFlag == false && cookieUuidFlag == false || !"true".equals(this.autoCheckLoginFlag)) {
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
                ResponseWrapper mr = new ResponseWrapper(response);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)mr);
                if (response.getWriter() != null && response.getContentType() != null && response.getContentType().toLowerCase().indexOf("text/html") >= 0) {
                    if (response.isCommitted()) {
                        return;
                    }
                    PrintWriter out = response.getWriter();
                    String result = mr.getResult();
                    if (result.toLowerCase().indexOf("</body>") > 0) {
                        if (cookLoginFlag.booleanValue() && !sessionLoginFlag.booleanValue()) {
                            result = result.replace("</body>", "<img style=\"display: none;\" src=\"" + this.autoCheckLoginStatusUrlPrefix + "/_autologin_/a.jpg\"></body>");
                        } else if (!(cookLoginFlag.booleanValue() && cookieUuidFlag.booleanValue() || !sessionLoginFlag.booleanValue())) {
                            result = result.replace("</body>", "<img style=\"display: none;\" src=\"" + this.casServerLoginUrl + "/checkStatus\"></body>");
                        }
                    }
                    if (result == null || "".equals(result)) {
                        this.logger.error("================== result is null :{}", (Object)result);
                    }
                    response.setContentLength(-1);
                    out.write(result);
                } else {
                    PrintWriter out = response.getWriter();
                    out.write(mr.getResult());
                }
                return;
            }
            finally {
                request.removeAttribute(ALREADY_FILTERED_SUFFIX);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected String makeLogoutUrl(String defaultUrl, HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    private final String getLoginImgStr(String url) {
        String script = "(function(){\n\tvar body = document.getElementsByTagName('body')[0];\n\tvar img = document.createElement(\"img\");\n\timg.src = '" + url + "';\n\timg.style.display='none'\n\tbody.appendChild(img); \n})();\n";
        return script;
    }

    public void serverLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String suffix = request.getQueryString() == null || "".equals(request.getQueryString()) ? "" : "?" + request.getQueryString();
        String service = URLEncoder.encode(request.getRequestURL() + suffix, "utf-8");
        String redirectLoginUrl = this.casServerLoginUrl + "?service=" + service;
        response.sendRedirect(redirectLoginUrl);
    }

    public void destroy() {
    }
}

