/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.statuscheck;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.client.authentication.AttributePrincipalImpl;
import org.jasig.cas.client.util.DomainUtils;
import org.jasig.cas.client.validation.AssertionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatSessionCheckFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(WechatSessionCheckFilter.class);
    public static final String ALREADY_FILTERED_SUFFIX = "WechatSessionCheckFilter.FILTERED";
    private String wechatSessionUrl;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.wechatSessionUrl = filterConfig.getInitParameter("wechatSessionUrl");
        if (this.wechatSessionUrl == null || "".equals(this.wechatSessionUrl.trim())) {
            throw new RuntimeException("wechat \u4f1a\u8bdd\u83b7\u53d6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u4e0d\u80fd\u4e3a\u7a7a \uff5bwechatSessionUrl\uff5d");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        boolean hasAlreadyFilteredAttribute;
        if (servletRequest.getAttribute("__pass_sso") != null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        boolean bl = hasAlreadyFilteredAttribute = request.getAttribute(ALREADY_FILTERED_SUFFIX) != null;
        if (hasAlreadyFilteredAttribute) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            block21: {
                request.setAttribute(ALREADY_FILTERED_SUFFIX, (Object)Boolean.TRUE);
                if (request.getAttribute("_const_cas_assertion_") != null || request.getSession() != null && request.getSession().getAttribute("_const_cas_assertion_") != null) {
                    filterChain.doFilter(servletRequest, servletResponse);
                    logger.info("\u5fae\u4fe1\u767b\u5f55\u72b6\u6001\u68c0\u67e5\uff1arequest.getSession()\u6216request.getSession().getAttribute(CONST_CAS_ASSERTION)\u4e0d\u4e3a\u7a7a");
                    return;
                }
                String userAgent = request.getHeader("User-Agent");
                try {
                    if (userAgent.toLowerCase().indexOf("micromessenger") <= 0) break block21;
                    logger.info("\u68c0\u67e5wechat cookie \u767b\u5f55");
                    String wk = null;
                    if (request.getCookies() != null) {
                        for (Cookie cookie : request.getCookies()) {
                            if (!"__wt".equals(cookie.getName())) continue;
                            wk = cookie.getValue();
                            break;
                        }
                    }
                    logger.info("\u5fae\u4fe1cookie\u4e2dwt\u7684\u503c\uff1a{}", wk);
                    if (wk == null || "".equals(wk.trim())) break block21;
                    URL url = new URL(this.wechatSessionUrl + wk);
                    URLConnection conn = null;
                    BufferedReader reader = null;
                    StringBuffer resultBuffer = null;
                    try {
                        conn = url.openConnection();
                        conn.setUseCaches(false);
                        conn.setConnectTimeout(5000);
                        conn.setRequestProperty("accept", "*/*");
                        conn.setRequestProperty("connection", "Keep-Alive");
                        conn.connect();
                        resultBuffer = new StringBuffer();
                        String tempLine = null;
                        reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        while ((tempLine = reader.readLine()) != null) {
                            resultBuffer.append(tempLine);
                        }
                    }
                    catch (IOException e) {
                        logger.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                    finally {
                        if (conn != null) {
                            // empty if block
                        }
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    if (resultBuffer != null) {
                        String[] props;
                        String responseStr = resultBuffer.toString();
                        responseStr = responseStr.replaceFirst("\\{", "").replaceFirst("\\}", "");
                        for (String prop : props = responseStr.split(",")) {
                            String[] kv = prop.split(":");
                            if (kv.length != 2) continue;
                            map.put(kv[0].replaceAll("\"", ""), kv[1].replaceAll("\"", ""));
                        }
                    }
                    logger.info("\u8c03\u7528wechatapi\u67e5\u8be2\u7528\u6237\u4fe1\u606fmap\uff1a{}", (Object)map.size());
                    if (map.size() > 0 && map.get("id") != null) {
                        AttributePrincipalImpl attributePrincipal = new AttributePrincipalImpl(map.get("id").toString(), map);
                        AssertionImpl assertion = new AssertionImpl(attributePrincipal, map);
                        request.setAttribute("_const_cas_assertion_", (Object)assertion);
                        if (request.getSession() != null) {
                            request.getSession().setAttribute("_const_cas_assertion_", (Object)assertion);
                        }
                        logger.info("\u8c03\u7528wechatapi\u8fd4\u56de\u7684\u7528\u6237\u4fe1\u606fset\uff1aCONST_CAS_ASSERTION");
                    } else {
                        logger.info("\u5fae\u4fe1cookie\u65e0\u6548\uff0c\u8fdb\u884c\u5220\u9664");
                        this.deleteWkCookie(request, response);
                    }
                }
                catch (IOException e) {
                    logger.error("cooke \u65e0\u6548\uff0c\u5904\u7406\u5931\u8d25", (Throwable)e);
                    this.deleteWkCookie(request, response);
                }
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private void deleteWkCookie(HttpServletRequest request, HttpServletResponse response) {
        try {
            Cookie cookie = new Cookie("__wt", "");
            String mainDomain = DomainUtils.getMainDomain(request.getServerName());
            cookie.setDomain(mainDomain);
            cookie.setPath("/");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String regexMapStr(String regex, String body) {
        Matcher matcher = Pattern.compile(regex).matcher(body);
        if (matcher.find()) {
            String ret = matcher.group(1);
            return ret;
        }
        return "";
    }

    public void destroy() {
    }
}

