/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.statuscheck;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.client.util.DomainUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatSessionCheckFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(WechatSessionCheckFilter.class);
    public static final String ALREADY_FILTERED_SUFFIX = "WechatSessionCheckFilter.FILTERED";
    private String wechatSessionUrl;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.wechatSessionUrl = filterConfig.getInitParameter("wechatSessionUrl");
        if (this.wechatSessionUrl == null || "".equals(this.wechatSessionUrl.trim())) {
            throw new RuntimeException("wechat \u4f1a\u8bdd\u83b7\u53d6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u4e0d\u80fd\u4e3a\u7a7a \uff5bwechatSessionUrl\uff5d");
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        boolean hasAlreadyFilteredAttribute;
        if (servletRequest.getAttribute("__pass_sso") != null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        boolean bl = hasAlreadyFilteredAttribute = request.getAttribute(ALREADY_FILTERED_SUFFIX) != null;
        if (hasAlreadyFilteredAttribute) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            request.setAttribute(ALREADY_FILTERED_SUFFIX, (Object)Boolean.TRUE);
            if (request.getAttribute("_const_cas_assertion_") != null || request.getSession() != null && request.getSession().getAttribute("_const_cas_assertion_") != null) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private void deleteWkCookie(HttpServletRequest request, HttpServletResponse response) {
        try {
            Cookie cookie = new Cookie("__wt", "");
            String mainDomain = DomainUtils.getMainDomain(request.getServerName());
            cookie.setDomain(mainDomain);
            cookie.setPath("/");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String regexMapStr(String regex, String body) {
        Matcher matcher = Pattern.compile(regex).matcher(body);
        if (matcher.find()) {
            String ret = matcher.group(1);
            return ret;
        }
        return "";
    }

    public void destroy() {
    }
}

