/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.client;

import com.caucho.hessian.client.HessianConnection;
import com.caucho.hessian.client.HessianConnectionFactory;
import com.caucho.hessian.client.HessianProxyFactory;
import com.caucho.hessian.client.HessianURLConnection;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HessianURLConnectionFactory
implements HessianConnectionFactory {
    private static final Logger log = Logger.getLogger(HessianURLConnectionFactory.class.getName());
    private HessianProxyFactory _proxyFactory;
    private long _chunklen = -1L;

    @Override
    public void setHessianProxyFactory(HessianProxyFactory factory) {
        this._proxyFactory = factory;
    }

    public void setChunkedStreamingMode(int chunklen) {
        this._chunklen = this._chunklen;
    }

    @Override
    public HessianConnection open(URL url) throws IOException {
        int chunkSize;
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " open(" + url + ")");
        }
        URLConnection conn = url.openConnection();
        long connectTimeout = this._proxyFactory.getConnectTimeout();
        if (connectTimeout >= 0L) {
            conn.setConnectTimeout((int)connectTimeout);
        }
        if ((chunkSize = this._proxyFactory.getChunkedSize()) > 0) {
            ((HttpURLConnection)conn).setChunkedStreamingMode(chunkSize);
        }
        conn.setDoOutput(true);
        long readTimeout = this._proxyFactory.getReadTimeout();
        if (readTimeout > 0L) {
            try {
                conn.setReadTimeout((int)readTimeout);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return new HessianURLConnection(url, conn);
    }
}

