/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.auth;

import com.cntaiping.intserv.basic.auth.login.ISLogin;
import com.cntaiping.intserv.basic.auth.login.UserOnline;
import com.cntaiping.intserv.basic.auth.user.ISUser;
import com.cntaiping.intserv.basic.auth.user.UserAccessClient;
import com.cntaiping.intserv.basic.runtime.Property;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class RootServlet
extends HttpServlet {
    private static final long serialVersionUID = -8752432991587973748L;
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String REQ_CHAR_ENCODING = "UTF-8";
    public static String ERROR_PAGE = "/intserv/facade/default/error.jsp";
    public static String INDEX_PAGE = "/intserv/facade/default/index.jsp";
    public static String MAIN_PAGE = "/intserv/facade/default/main.jsp";
    public static String facade = "default";
    public static boolean templatized = false;

    static {
        try {
            facade = Property.getProperty(0, "INTSERV_FACADE", "default");
            ERROR_PAGE = "/intserv/facade/" + facade + "/error.jsp";
            INDEX_PAGE = "/intserv/facade/" + facade + "/index.jsp";
            MAIN_PAGE = "/intserv/facade/" + facade + "/main.jsp";
            if ("TILES".equalsIgnoreCase(Property.getProperty(0, "TEMPLATE_ENGINE", "NONE"))) {
                templatized = true;
                ERROR_PAGE = "/intserv.facade." + facade + ".error.screen";
                INDEX_PAGE = "/intserv.facade." + facade + ".index.screen";
                MAIN_PAGE = "/intserv.facade." + facade + ".main.screen";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init() throws ServletException {
    }

    public abstract void process(HttpServletRequest var1, HttpServletResponse var2, ISUser var3) throws Exception;

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding(REQ_CHAR_ENCODING);
        try {
            ISUser user = null;
            String winkToken = request.getParameter("AUTH_TOKEN");
            if (winkToken != null && !"".equals(winkToken)) {
                user = ISLogin.crossLogin(request, winkToken);
                if (user == null) {
                    this.gotoLoginPage(request, response, "crossDeny");
                    return;
                }
            } else {
                HttpSession session = request.getSession(false);
                if (session == null) {
                    this.gotoLoginPage(request, response, "sessionLost");
                    return;
                }
                user = (ISUser)session.getAttribute("INTSERV_USER");
                if (user == null) {
                    this.gotoLoginPage(request, response, "sessionLost");
                    return;
                }
                if (!UserAccessClient.checkURI(user, request)) {
                    this.gotoLoginPage(request, response, "authDeny");
                    return;
                }
            }
            if (UserOnline.visitCacheValue(user.getUserId()) != 0) {
                this.log.info("visit refused:" + user.getUserName() + ",online limit");
                this.gotoLoginPage(request, response, "onlineLimit");
                return;
            }
            this.process(request, response, user);
        }
        catch (Exception ex) {
            this.handelException(request, response, ex);
        }
    }

    protected void gotoLoginPage(HttpServletRequest request, HttpServletResponse response, String loginMsg) throws ServletException, IOException {
        request.setAttribute("is_loginFwdURI", (Object)request.getRequestURI());
        request.setAttribute("is_loginFwdPath", (Object)request.getServletPath());
        request.setAttribute("is_fwdParamMap", (Object)this.getParameterMap(request));
        request.setAttribute("is_loginMsg", (Object)loginMsg);
        this.forward(request, response, INDEX_PAGE);
    }

    /*
     * Unable to fully structure code
     */
    protected Map getParameterMap(HttpServletRequest request) {
        block4: {
            try {
                map = request.getParameterMap();
                break block4;
            }
            catch (Throwable ex) {
                map = new HashMap<String, Object>();
                names = request.getParameterNames();
                ** while (names.hasMoreElements())
            }
lbl-1000:
            // 1 sources

            {
                name = (String)names.nextElement();
                values = request.getParameterValues(name);
                if (values != null && values.length == 1) {
                    map.put(name, values[0]);
                    continue;
                }
                map.put(name, values);
                continue;
            }
        }
        return map;
    }

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public final void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.service(request, response);
    }

    protected void debug(Object obj) {
        this.log.debug(obj);
    }

    protected void debug(Object obj, Throwable thr) {
        this.log.debug(obj, thr);
    }

    protected void forward(HttpServletRequest request, HttpServletResponse response, String url) throws ServletException, IOException {
        RequestDispatcher rd = request.getRequestDispatcher(url);
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void include(HttpServletRequest request, HttpServletResponse response, String url) throws ServletException, IOException {
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(url);
        rd.include((ServletRequest)request, (ServletResponse)response);
    }

    protected void redirect(HttpServletResponse response, String url) throws ServletException, IOException {
        response.sendRedirect(response.encodeRedirectURL(url));
    }

    protected void handleError(HttpServletRequest request, HttpServletResponse response, Exception exception) {
        try {
            this.handelException(request, response, exception);
        }
        catch (Exception ex) {
            if (RuntimeException.class.isInstance(ex)) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    protected void handelException(HttpServletRequest request, HttpServletResponse response, Exception exception) throws ServletException, IOException {
        this.log.info("Exception caught: " + exception);
        this.log.debug(exception);
        if (exception instanceof ServletException) {
            throw (ServletException)((Object)exception);
        }
        request.setAttribute("url", (Object)request.getRequestURI());
        request.setAttribute("javax.servlet.error.exception", (Object)exception);
        request.setAttribute("javax.servlet.jsp.jspException", (Object)exception);
        if (!response.isCommitted()) {
            this.forward(request, response, ERROR_PAGE);
        } else {
            try {
                this.include(request, response, ERROR_PAGE);
            }
            catch (IOException e) {
                this.log.error((Object)("IOException when trying to include the error page path " + ERROR_PAGE), e);
            }
            catch (ServletException e) {
                this.log.error((Object)("ServletException when trying to include the error page path " + ERROR_PAGE), e);
            }
        }
    }

    protected void setReadonly(HttpServletRequest request, boolean isReadonly) {
        request.setAttribute("com.cntaiping.intserv.basic.auth.READONLY", (Object)isReadonly);
    }

    public void destroy() {
        super.destroy();
    }
}

