/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.auth.employee;

import com.cntaiping.intserv.basic.auth.employee.ISAgentAgent;
import com.cntaiping.intserv.basic.auth.employee.ISBankAgent;
import com.cntaiping.intserv.basic.auth.employee.ISBankEmployee;
import com.cntaiping.intserv.basic.auth.user.ISUser;
import com.cntaiping.intserv.basic.auth.user.UserAccessClient;
import com.cntaiping.intserv.basic.auth.user.remote.ExtUserAccessClient;
import com.cntaiping.intserv.basic.runtime.db.DBUtil;
import com.cntaiping.intserv.basic.runtime.db.DBUtilExt;
import com.cntaiping.intserv.basic.util.Tools;
import com.cntaiping.intserv.basic.util.exception.AppException;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmployeeArchBean {
    private static Log log = LogFactory.getLog(EmployeeArchBean.class);

    public static ISBankEmployee getBankEmployee(String userId, String bankCode, String teller, String ip) throws AppException {
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        String sql = null;
        ISBankEmployee employee = new ISBankEmployee();
        try {
            try {
                conn = DBUtil.getConnection();
                pst = conn.prepareStatement("select u.user_cate,u.raw_staff_id,u.head_id,u.organ_id,t.agent_team_type from is_ac_user u,t_agent t where u.raw_staff_id = t.agent_id and u.user_id= ? ");
                pst.setString(1, userId);
                rs = pst.executeQuery();
                String user_cate = null;
                if (rs.next()) {
                    user_cate = rs.getString("USER_CATE");
                    if (!"102".equals(user_cate) && !"105".equals(user_cate)) {
                        throw new AppException(1001, "getBankEmployee() failed:user_cate is " + rs.getString("USER_CATE"));
                    }
                } else {
                    throw new AppException(1002, "getBankEmployee() failed:user(" + userId + ") is not exist.");
                }
                employee.setUserId(userId);
                employee.setRawStaffId(rs.getString("RAW_STAFF_ID"));
                employee.setHeadId(rs.getString("HEAD_ID"));
                employee.setOrganId(rs.getString("ORGAN_ID"));
                employee.setAgentTeamType(rs.getInt("agent_team_type"));
                rs.close();
                pst.close();
                if ("102".equals(user_cate)) {
                    String bank;
                    employee.setDept(bankCode);
                    employee.setTeller(teller);
                    if ("9988".equals(bankCode.substring(0, 4)) || "9985".equals(bankCode.substring(0, 4))) {
                        employee.setTeller(employee.getRawStaffId());
                    }
                    pst = conn.prepareStatement("select organ_id,bank_code,branch_bank,status from t_bank where bank_code=?");
                    pst.setString(1, bankCode);
                    rs = pst.executeQuery();
                    if (rs.next()) {
                        if (!"1".equals(rs.getString("STATUS"))) {
                            throw new AppException(1006, "getBankEmployee() failed:bank(" + bankCode + ") status is " + rs.getString("STATUS") + ";\u8be5\u94f6\u884c\u7f51\u70b9\u7684\u72b6\u6001\u975e\u6709\u6548");
                        }
                        bank = bankCode.substring(0, 4);
                        if (!rs.getString("BRANCH_BANK").startsWith(bank)) {
                            throw new AppException(1007, "getBankEmployee() failed:bank or branch is wrong.");
                        }
                    } else {
                        throw new AppException(1008, "getBankEmployee() failed:bank(" + bankCode + ") is not exist.");
                    }
                    employee.setBank(bank);
                    employee.setZone(rs.getString("BRANCH_BANK"));
                    rs.close();
                    pst.close();
                    sql = "select b.organ_id,b.dept_id,b.agent_id\n  from t_bank_agent a,t_agent b\n  where a.agent_id=b.agent_id\n    and b.agent_status=1\n    and a.bank_code=?";
                    pst = conn.prepareStatement(sql);
                    pst.setString(1, bankCode);
                    rs = pst.executeQuery();
                    if (rs.next()) {
                        if (!employee.getOrganId().equals(rs.getString("ORGAN_ID"))) {
                            throw new AppException(1009, "getBankEmployee() failed:user or agent's organ_id is wrong.");
                        }
                    } else {
                        throw new AppException(1010, "getBankEmployee() failed:cannot find any valid agent.");
                    }
                    employee.setDeptId(rs.getString("DEPT_ID"));
                    employee.setAgentId(rs.getString("AGENT_ID"));
                    rs.close();
                    pst.close();
                    sql = "select (case  when class_id  >2 then substr(organ_id,1,3) else organ_id end) organ_id    from t_company_organ     where organ_id = ?       ";
                    Map result = DBUtilExt.querySingle(sql, employee.getOrganId());
                    employee.setOrganId(Tools.toString(result.get("organId")));
                } else if (user_cate.equals("105")) {
                    employee.setBank("-1");
                    sql = "select b.organ_id,b.dept_id,b.agent_id\n  from  t_agent b\n where b.agent_status=1\n    and b.agent_id=?";
                    pst = conn.prepareStatement(sql);
                    pst.setString(1, employee.getRawStaffId());
                    rs = pst.executeQuery();
                    if (rs.next()) {
                        if (!employee.getOrganId().equals(rs.getString("ORGAN_ID"))) {
                            throw new AppException(1009, "getBankEmployee() failed:user or agent's organ_id is wrong.");
                        }
                    } else {
                        throw new AppException(1010, "getBankEmployee() failed:cannot find any valid agent.");
                    }
                    employee.setDeptId(rs.getString("DEPT_ID"));
                    employee.setAgentId(rs.getString("AGENT_ID"));
                    rs.close();
                    pst.close();
                }
                String url = "";
                sql = "select url from is_bank_ip_config where url_mode=?";
                Map resultMap = DBUtilExt.querySingle(sql, "0");
                if (resultMap != null) {
                    url = Tools.toString(resultMap.get("url"));
                }
                if (url.equals(ip.substring(0, 3))) {
                    employee.setIsOuterNet(0);
                } else {
                    employee.setIsOuterNet(1);
                }
            }
            catch (SQLException e) {
                log.error((Object)("getBankEmployee(" + userId + ") failed:"), e);
                throw new AppException(1011, "getBankEmployee() failed:" + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, pst, conn);
            throw throwable;
        }
        DBUtil.close(rs, pst, conn);
        return employee;
    }

    public static ISBankAgent getAgentInfo(String agentId) throws AppException {
        ISBankAgent agent = new ISBankAgent();
        try {
            List bankList = EmployeeArchBean.getBankList(agentId);
            HashMap<String, List> bankCodeMap = new HashMap<String, List>();
            int i = 0;
            while (i < bankList.size()) {
                Map bankMap = (Map)bankList.get(i);
                String bank = Tools.toString(bankMap.get("bankCode"));
                List bankCodeList = EmployeeArchBean.getBankCodeList(agentId, bank);
                bankCodeMap.put(bank, bankCodeList);
                ++i;
            }
            HashMap<String, List> tellerMap = new HashMap<String, List>();
            List bankCodeList = EmployeeArchBean.getBankCodeList(agentId);
            int i2 = 0;
            while (i2 < bankCodeList.size()) {
                Map m = (Map)bankCodeList.get(i2);
                String bankCode = Tools.toString(m.get("bankCode"));
                List tellerList = EmployeeArchBean.getTellerList(bankCode);
                tellerMap.put(bankCode, tellerList);
                ++i2;
            }
            agent.setAgentId(agentId);
            agent.setBankList(bankList);
            agent.setBankCodeMap(bankCodeMap);
            agent.setTellerMap(tellerMap);
        }
        catch (Exception e) {
            log.error((Object)("getAgentInfo(" + agentId + ") failed:"), e);
            throw new AppException(1012, "getAgentInfo() failed:" + e.getMessage());
        }
        return agent;
    }

    public static List getBankList(String agentId) throws AppException {
        List bankList = new ArrayList();
        StringBuffer sql = new StringBuffer();
        try {
            sql.append("select bank_code,bank_name                       ");
            sql.append("  from t_bank                                    ");
            sql.append(" where bank_code in (                            ");
            sql.append("       select distinct substr(a.bank_code,1,4)   ");
            sql.append("         from t_bank_agent a,t_bank b,t_agent ta ");
            sql.append("        where a.bank_code=b.bank_code            ");
            sql.append("          and ta.agent_id=a.agent_id             ");
            sql.append("          and ta.agent_status=1                  ");
            sql.append("          and b.status=1                         ");
            sql.append("          and a.agent_id=? )                     ");
            sql.append(" order by bank_code                              ");
            bankList = DBUtilExt.query(sql.toString(), agentId);
        }
        catch (Exception e) {
            log.error((Object)("getBankList(" + agentId + ") failed:"), e);
            throw new AppException(1013, "getBankList() failed:" + e.getMessage());
        }
        return bankList;
    }

    public static List getBankCodeList(String agentId) throws AppException {
        List bankCodeList = new ArrayList();
        StringBuffer sql = new StringBuffer();
        try {
            sql.append("select distinct a.bank_code,b.bank_name   ");
            sql.append("  from t_bank_agent a,t_bank b,t_agent ta ");
            sql.append(" where a.bank_code=b.bank_code            ");
            sql.append("   and ta.agent_id=a.agent_id             ");
            sql.append("   and ta.agent_status=1                  ");
            sql.append("   and b.status=1                         ");
            sql.append("   and a.agent_id=?                       ");
            sql.append(" order by bank_code                       ");
            bankCodeList = DBUtilExt.query(sql.toString(), new Object[]{agentId});
        }
        catch (Exception e) {
            log.error((Object)("getDeptList(" + agentId + ") failed:"), e);
            throw new AppException(1014, "getDeptList() failed:" + e.getMessage());
        }
        return bankCodeList;
    }

    public static List getBankCodeList(String agentId, String bank) throws AppException {
        List bankCodeList = new ArrayList();
        StringBuffer sql = new StringBuffer();
        try {
            sql.append("select distinct a.bank_code,b.bank_name   ");
            sql.append("  from t_bank_agent a,t_bank b,t_agent ta ");
            sql.append(" where a.bank_code=b.bank_code            ");
            sql.append("   and ta.agent_id=a.agent_id             ");
            sql.append("   and ta.agent_status=1                  ");
            sql.append("   and b.status=1                         ");
            sql.append("   and substr(a.bank_code,1,4)=?          ");
            sql.append("   and a.agent_id=?                       ");
            sql.append(" order by bank_code                       ");
            bankCodeList = DBUtilExt.query(sql.toString(), new Object[]{bank, agentId});
        }
        catch (Exception e) {
            log.error((Object)("getDeptList(" + agentId + "," + bank + ") failed:"), e);
            throw new AppException(1014, "getDeptList() failed:" + e.getMessage());
        }
        return bankCodeList;
    }

    public static List getTellerList(String bankCode) throws AppException {
        boolean flag = false;
        StringBuffer sql = new StringBuffer();
        List tellerList = new ArrayList();
        try {
            sql.append("select e.internal_code from t_bank_employee e where e.status=1 and  e.bank_code like ? ");
            tellerList = DBUtilExt.query(sql.toString(), String.valueOf(bankCode) + "%");
        }
        catch (Exception e) {
            log.error((Object)("getEmpCodeList(" + bankCode + ") failed:"), e);
            throw new AppException(1015, "getEmpCodeList() failed:" + e.getMessage());
        }
        return tellerList;
    }

    public static String getTeller(String bankCode, String empCode) throws AppException {
        String teller = "";
        try {
            String sqlStr = "select e.internal_code from t_bank_employee e where  e.bank_code = ? and e.emp_code= ?";
            Map resultMap = DBUtilExt.querySingle(sqlStr, new Object[]{bankCode, empCode});
            teller = Tools.toString(resultMap.get("internalCode"));
        }
        catch (Exception e) {
            log.error((Object)("getTeller(" + bankCode + "," + empCode + ") failed:"), e);
            throw new AppException(1015, "getTeller() failed:" + e.getMessage());
        }
        return teller;
    }

    public static ISAgentAgent getAgent(String userId) throws AppException {
        ISAgentAgent agent = new ISAgentAgent();
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        String sql = null;
        try {
            try {
                conn = DBUtil.getConnection();
                pst = conn.prepareStatement("select RAW_STAFF_ID,HEAD_ID from is_ac_user where user_id=?");
                pst.setString(1, userId);
                rs = pst.executeQuery();
                if (!rs.next()) {
                    throw new AppException(1002, "getAgent() failed:user(" + userId + ") is not exist.");
                }
                agent.setUserId(userId);
                agent.setRawStaffId(rs.getString("RAW_STAFF_ID"));
                agent.setAgentId(rs.getString("RAW_STAFF_ID"));
                agent.setHeadId(rs.getString("HEAD_ID"));
                rs.close();
                pst.close();
                sql = "select a.agent_id,a.agent_code,a.dept_id,a.organ_id,c.grade_name,a.real_name,a.celler_tel,a.telephone,\n       case when a.agent_cate='1' then c.grade_name\n            when a.agent_cate in ('4') then\n         (select m.post_name from t_b_technical_post m where m.post_id=a.b_technical_post)\n            when a.agent_cate='7' then\n         (select m.post_name from t_s_technical_post m where m.post_id=a.s_technical_post)\n            end grade_name,\n       a.email,b.address,a.practice_id\n  from t_agent a,t_company_organ b,t_agent_grade c\n  where a.organ_id=b.organ_id(+)\n    and a.grade_id=c.grade_id(+)\n    and a.agent_status=1\n    and a.agent_id=?\n";
                pst = conn.prepareStatement(sql);
                pst.setString(1, agent.getAgentId());
                rs = pst.executeQuery();
                if (!rs.next()) {
                    throw new AppException(1010, "getAgent() failed:cannot find any valid agent.");
                }
                agent.setAgentCode(rs.getString("AGENT_CODE"));
                agent.setDeptId(rs.getString("DEPT_ID"));
                agent.setOrganId(rs.getString("ORGAN_ID"));
                agent.setGradeName(rs.getString("grade_name"));
                agent.setRealName(rs.getString("real_name"));
                agent.setCellerTel(rs.getString("celler_tel"));
                agent.setTelephone(rs.getString("telephone"));
                agent.setEmail(rs.getString("email"));
                agent.setOrganAddress(rs.getString("address"));
                agent.setMarketCode(rs.getString("practice_id"));
                rs.close();
                pst.close();
                pst = conn.prepareStatement("SELECT principal_id from t_dept WHERE  dept_id= ?");
                pst.setString(1, agent.getDeptId());
                rs = pst.executeQuery();
                if (rs.next()) {
                    String result = Tools.toString(rs.getString("PRINCIPAL_ID"));
                    if (agent.getAgentId().equals(result)) {
                        agent.setManagerFlag(1);
                    } else {
                        agent.setManagerFlag(0);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("getAgent failed." + sql + "," + userId), e);
                throw new AppException(1016, "getAgent() failed:" + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, pst, conn);
            throw throwable;
        }
        DBUtil.close(rs, pst, conn);
        return agent;
    }

    public static String getAgentB(String userId) throws AppException {
        ISAgentAgent agent = EmployeeArchBean.getAgent(userId);
        return agent.getAgentCode();
    }

    public static ISAgentAgent getRenewAgent(String userId) throws AppException {
        ISAgentAgent agent = new ISAgentAgent();
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            try {
                conn = DBUtil.getConnection();
                pst = conn.prepareStatement("select RAW_STAFF_ID,HEAD_ID from is_ac_user where user_id=?");
                pst.setString(1, userId);
                rs = pst.executeQuery();
                if (!rs.next()) {
                    throw new AppException(1017, "getRenewAgent() failed:user(" + userId + ") is not exist.");
                }
                agent.setUserId(userId);
                agent.setRawStaffId(rs.getString("RAW_STAFF_ID"));
                agent.setAgentId(rs.getString("RAW_STAFF_ID"));
                agent.setHeadId(rs.getString("HEAD_ID"));
                rs.close();
                pst.close();
                pst = conn.prepareStatement("select agent_id,agent_code,dept_id,organ_id from t_agent where agent_id=? and agent_status=1");
                pst.setString(1, agent.getAgentId());
                rs = pst.executeQuery();
                if (!rs.next()) {
                    throw new AppException(1010, "getAgent() failed:cannot find any valid agent.");
                }
                agent.setAgentCode(rs.getString("AGENT_CODE"));
                agent.setDeptId(rs.getString("DEPT_ID"));
                agent.setOrganId(rs.getString("ORGAN_ID"));
                rs.close();
                pst.close();
                ISUser isUser = UserAccessClient.getUserByUserId(userId);
                isUser = ExtUserAccessClient.getISUser((int)12, (int)Tools.toInteger(isUser.getUserCate()), (long)Tools.toLong(isUser.getRawStaffId()));
                agent.setManagerFlag(Math.abs(Tools.toInteger(isUser.getHeadId())));
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new AppException(1016, "getRenewAgent() failed:" + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, pst, conn);
            throw throwable;
        }
        DBUtil.close(rs, pst, conn);
        return agent;
    }

    public static List<Map> getSubOrganList(String userId) throws AppException {
        ArrayList<Map> organList = new ArrayList<Map>();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        StringBuffer sb = new StringBuffer();
        try {
            try {
                con = DBUtil.getConnection();
                sb.append("SELECT C.PARENT_ID,C.ORGAN_ID,C.ABBR_NAME FROM T_COMPANY_ORGAN C, ");
                sb.append("(SELECT * FROM  IS_AC_USER WHERE USER_ID=? ) A ");
                sb.append("START WITH C.ORGAN_ID = A.ORGAN_ID CONNECT BY  C.PARENT_ID = PRIOR C.ORGAN_ID");
                ps = con.prepareStatement(sb.toString());
                ps.setString(1, userId);
                rs = ps.executeQuery();
                while (rs.next()) {
                    HashMap<String, String> organMap = new HashMap<String, String>();
                    organMap.put("parentId", Tools.toString(rs.getString("PARENT_ID")));
                    organMap.put("organId", Tools.toString(rs.getString("ORGAN_ID")));
                    organMap.put("organName", Tools.toString(rs.getString("ABBR_NAME")));
                    organList.add(organMap);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new AppException(1018, "getSubOrganList() failed:" + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, ps, con);
            throw throwable;
        }
        DBUtil.close(rs, ps, con);
        return organList;
    }

    public static List getUserList(String organId, String moduleId) throws AppException {
        List resultList = null;
        try {
            String sql = " select distinct t.user_id from is_ac_user t, is_ac_user_role t1, is_ac_role_module t2  where t.user_id = t1.user_id and t1.role_id = t2.role_id  and t.organ_id = ?     and t2.module_id = ? and user_cate = '101' ";
            resultList = DBUtilExt.query(sql, new String[]{organId, moduleId});
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new AppException(1019, "getUserList() failed:" + e.getMessage());
        }
        return resultList;
    }
}

