/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.auth.login;

import com.cntaiping.intserv.basic.auth.user.ISUser;
import com.cntaiping.intserv.basic.auth.user.UserAccessClient;
import com.cntaiping.intserv.basic.runtime.Property;
import com.cntaiping.intserv.basic.util.Tools;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import com.cntaiping.intserv.basic.util.security.ConvertPassword;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class AuthLogin {
    private static Log log = LogFactory.getLog(AuthLogin.class);

    public static String changePassword(String userName, String password) throws Exception {
        ISUser isUser = UserAccessClient.getUserModel(userName);
        if (isUser == null) {
            return password;
        }
        if ("1".equals(isUser.getEncryption())) {
            password = ConvertPassword.digestPassword(password, isUser.getUserCate(), isUser.getRawStaffId());
        }
        return password;
    }

    public static boolean loginCheck(HttpServletRequest request, String userName, String password) throws Exception {
        String sysNo = Property.getProperty(0, "INTSERV_PLANT_ID");
        userName = userName.toLowerCase();
        Map resultMap = UserAccessClient.checkLogin(userName, password, sysNo);
        String result = Tools.toString(resultMap.get("result"));
        String message = Tools.toString(resultMap.get("message"));
        log.info("checkLogin result:" + result);
        log.info("checkLogin message:" + message);
        if ("first_login".equals(message) || "remind_day".equals(message) || "cross_day".equals(message)) {
            request.setAttribute("is_remind", (Object)message);
            request.setAttribute("effDay", (Object)Tools.toString(resultMap.get("effDay")));
        } else if ("choose_teller".equals(message)) {
            request.setAttribute("is_choose_teller_info", (Object)"true");
        } else {
            request.setAttribute("is_loginMsg", (Object)message);
        }
        request.setAttribute("userName", (Object)userName);
        request.setAttribute("password", (Object)password);
        if ("success".equals(result) && "".equals(message)) {
            log.info("loginCheck success!");
            return true;
        }
        log.info("loginCheck failure!");
        return false;
    }
}

