/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.auth.login;

import com.cntaiping.intserv.basic.auth.employee.EmployeeArchClient;
import com.cntaiping.intserv.basic.auth.employee.ISBankEmployee;
import com.cntaiping.intserv.basic.auth.login.UserOnline;
import com.cntaiping.intserv.basic.auth.secure.Operator;
import com.cntaiping.intserv.basic.auth.user.ISUser;
import com.cntaiping.intserv.basic.auth.user.UserAccessClient;
import com.cntaiping.intserv.basic.auth.user.UserAccessConfig;
import com.cntaiping.intserv.basic.runtime.Property;
import com.cntaiping.intserv.basic.runtime.plant.Plant;
import com.cntaiping.intserv.basic.util.Tools;
import com.cntaiping.intserv.basic.util.exception.AppException;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import com.cntaiping.intserv.basic.util.web.BrowserUser;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ISLogin {
    private static Log log = LogFactory.getLog(ISLogin.class);
    private static int plantId = -1;

    static {
        try {
            plantId = Integer.parseInt(Property.getProperty(0, "INTSERV_PLANT_ID"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ISUser login(HttpServletRequest request, String userName, String encPassword) throws Exception {
        UserAccessConfig config;
        Operator oper;
        String ip;
        HttpSession session;
        block11: {
            log.info("login user:" + userName);
            session = request.getSession(true);
            String sid = session.getId();
            ip = BrowserUser.getIpAddr(request);
            userName = userName.toLowerCase();
            oper = new Operator();
            oper.setIpAddr(ip);
            oper.setPlantId(plantId);
            config = null;
            try {
                session.removeAttribute("INTSERV_TOKEN");
                session.removeAttribute("INTSERV_USER");
                config = UserAccessClient.verify(userName, encPassword, sid, oper);
                if (config != null && config.getToken() != null && !"".equals(config.getToken())) break block11;
                log.info("token lost:" + userName);
                return null;
            }
            catch (AppException appEx) {
                log.info("login failed:" + userName + "," + appEx.getErrCode() + "-" + appEx.getMessage());
                request.setAttribute("is_loginMsg", (Object)appEx.getMessage());
                request.setAttribute("userName", (Object)userName);
                return null;
            }
        }
        if (config.getIsFirstLogin() == 1) {
            request.setAttribute("is_remind", (Object)"first_login");
        } else if (config.getHintChange() != 0) {
            request.setAttribute("is_remind", (Object)"remind_day");
            request.setAttribute("effDay", (Object)config.getHintDays());
        }
        log.info("login success:" + userName);
        if (UserOnline.visitCacheValue(config.getUserId()) != 0) {
            log.info("login refused:" + userName + ",online limit");
            request.setAttribute("is_loginMsg", (Object)"onlineLimit");
            return null;
        }
        oper.setUserId(config.getUserId());
        oper.setAuthToken(config.getToken());
        ISUser user = UserAccessClient.getUserModel(plantId, oper);
        if (user == null) {
            log.info("cannot found user!");
            return null;
        }
        if (config.getSessionTime() > 0) {
            session.setMaxInactiveInterval(config.getSessionTime());
        }
        session.setAttribute("INTSERV_TOKEN", (Object)config.getToken());
        session.setAttribute("INTSERV_USER", (Object)user);
        if ("102".equals(user.getUserCate()) || "105".equals(user.getUserCate())) {
            if ("102".equals(user.getUserCate()) && Tools.toString(request.getParameter("bankCode")).length() == 0) {
                request.setAttribute("is_choose_teller_info", (Object)"true");
                return user;
            }
            String bankCode = Tools.toString(request.getParameter("bankCode"));
            String teller = Tools.toString(request.getParameter("teller"));
            ISBankEmployee bankEmployee = EmployeeArchClient.getBankEmployee(user.getUserId(), bankCode, teller, ip);
            request.getSession().setAttribute("bankEmployee", (Object)bankEmployee);
        }
        log.info("loginUserInfos:{ userName=" + user.getUserName() + " , userId=" + user.getUserId() + " , rawStaffCode=" + user.getRawStaffCode() + " , rawStaffId=" + user.getRawStaffId() + " , userCate=" + user.getUserCate() + " , organId=" + user.getOrganId() + " , deptCode=" + user.getDeptCode() + " }" + " , clientIP=" + ip + " , User-Agent=" + request.getHeader("User-Agent"));
        return user;
    }

    public static ISUser crossLogin(HttpServletRequest request, String winkToken) throws Exception {
        String token = UserAccessClient.crossVerify(Plant.getLocalId(), winkToken);
        ISUser user = null;
        String token_c = null;
        HttpSession session = request.getSession(true);
        if (session != null) {
            token_c = (String)session.getAttribute("INTSERV_TOKEN");
        }
        if (token.equals(token_c)) {
            user = (ISUser)session.getAttribute("INTSERV_USER");
        } else {
            user = UserAccessClient.getUserModel(Plant.getLocalId(), token);
            session.setAttribute("INTSERV_TOKEN", (Object)token);
            session.setAttribute("INTSERV_USER", (Object)user);
        }
        if (user == null) {
            log.info("cannot verify winkToken! " + winkToken);
            return null;
        }
        log.info("cross login sucess:" + user.getUserName());
        log.info("loginUserInfos:{ userName=" + user.getUserName() + " , userId=" + user.getUserId() + " , rawStaffCode=" + user.getRawStaffCode() + " , rawStaffId=" + user.getRawStaffId() + " , userCate=" + user.getUserCate() + " , organId=" + user.getOrganId() + " , deptCode=" + user.getDeptCode() + " }" + " , clientIP=" + BrowserUser.getIpAddr(request) + " , User-Agent=" + request.getHeader("User-Agent"));
        return user;
    }

    public static void logout(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            ISUser user;
            String token = (String)session.getAttribute("INTSERV_TOKEN");
            if (token != null && !"".equals(token)) {
                try {
                    UserAccessClient.revoke(Plant.getLocalId(), token);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((user = (ISUser)session.getAttribute("INTSERV_USER")) != null) {
                UserOnline.removeCacheValue(user.getUserId());
            }
            session.removeAttribute("INTSERV_TOKEN");
            session.removeAttribute("INTSERV_USER");
        }
    }

    public static ISUser getISUser(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        ISUser user = (ISUser)session.getAttribute("INTSERV_USER");
        return user;
    }
}

