/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.auth.login;

import com.cntaiping.intserv.basic.auth.RootServlet;
import com.cntaiping.intserv.basic.auth.login.ISLogin;
import com.cntaiping.intserv.basic.auth.user.ISUser;
import com.cntaiping.intserv.basic.auth.user.UserAccessClient;
import com.cntaiping.intserv.basic.runtime.Property;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import com.cntaiping.intserv.basic.util.security.ConvertPassword;
import com.cntaiping.intserv.basic.util.security.RSAUtil;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LoginServlet
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = 1928866841890413473L;
    private static Log log = LogFactory.getLog(LoginServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sAction = request.getParameter("_login_sAction");
        log.info("_login_sAction=" + sAction + " , User-Agent=" + request.getHeader("User-Agent"));
        try {
            if ("logout".equals(sAction)) {
                HttpSession session = request.getSession(false);
                if (session != null) {
                    ISLogin.logout(request);
                    session.invalidate();
                }
                request.setAttribute("is_loginMsg", (Object)"logout");
                request.getRequestDispatcher(RootServlet.INDEX_PAGE).forward((ServletRequest)request, (ServletResponse)response);
            } else if ("crossLogin".equals(sAction)) {
                String winkToken = request.getParameter("AUTH_TOKEN");
                if (winkToken != null && !"".equals(winkToken) && ISLogin.crossLogin(request, winkToken) != null) {
                    String loginFwdPath = RootServlet.MAIN_PAGE;
                    request.removeAttribute("is_loginFwdPath");
                    request.getRequestDispatcher(loginFwdPath).forward((ServletRequest)request, (ServletResponse)response);
                } else {
                    request.setAttribute("is_loginMsg", (Object)"crossDeny");
                    request.getRequestDispatcher(RootServlet.INDEX_PAGE).forward((ServletRequest)request, (ServletResponse)response);
                }
            } else {
                String pattern;
                String userName = request.getParameter("_login_user_name");
                String password = request.getParameter("_login_password");
                String verifyCode = request.getParameter("_login_verify_code");
                String pwdFlag = Property.getProperty(0, "IS_RSA");
                if ("1".equals(pwdFlag)) {
                    password = RSAUtil.decrypt(request, password);
                }
                if ((pattern = Property.getProperty(0, "LOGIN_VERIFY_PATTERN")) != null && !"".equals(pattern)) {
                    if (verifyCode == null || "".equals(verifyCode)) {
                        request.setAttribute("is_loginMsg", (Object)"loginLack");
                        request.getRequestDispatcher(RootServlet.INDEX_PAGE).forward((ServletRequest)request, (ServletResponse)response);
                        return;
                    }
                    HttpSession session = request.getSession();
                    if (session == null || !verifyCode.equals(session.getAttribute("INTSERV_VERIFY_CODE"))) {
                        request.setAttribute("is_loginMsg", (Object)"loginIncorrect");
                        request.getRequestDispatcher(RootServlet.INDEX_PAGE).forward((ServletRequest)request, (ServletResponse)response);
                        return;
                    }
                }
                if (userName == null || "".equals(userName) || password == null || "".equals(password)) {
                    request.setAttribute("is_loginMsg", (Object)"loginLack");
                    request.getRequestDispatcher(RootServlet.INDEX_PAGE).forward((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                ISUser user = UserAccessClient.getISUserByName(userName = userName.toLowerCase());
                if (user == null) {
                    request.setAttribute("is_loginMsg", (Object)"loginIncorrect");
                    request.getRequestDispatcher(RootServlet.INDEX_PAGE).forward((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                password = ConvertPassword.firstEncrypt(Integer.parseInt(user.getUserCate()), password);
                if (ISLogin.login(request, userName, password) != null) {
                    String loginFwdPath = (String)request.getAttribute("is_loginFwdPath");
                    if (loginFwdPath == null || loginFwdPath.trim().length() == 0 || loginFwdPath.equals(request.getContextPath())) {
                        loginFwdPath = RootServlet.MAIN_PAGE;
                    }
                    request.removeAttribute("is_loginFwdPath");
                    request.getRequestDispatcher(loginFwdPath).forward((ServletRequest)request, (ServletResponse)response);
                } else {
                    request.getRequestDispatcher(RootServlet.INDEX_PAGE).forward((ServletRequest)request, (ServletResponse)response);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            request.setAttribute("exception", (Object)ex);
            request.getRequestDispatcher(RootServlet.ERROR_PAGE).forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

