/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.auth.login;

import com.cntaiping.intserv.basic.auth.login.UserOnlineThread;
import com.cntaiping.intserv.basic.runtime.Property;
import com.cntaiping.intserv.basic.runtime.plant.PlantAccessClient;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import java.io.Serializable;
import java.util.Date;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;

public class UserOnline {
    private static Log log = LogFactory.getLog(UserOnline.class);
    private static int plantId = -1;
    private static String serverAddr = null;
    private static String serverPort = null;
    private static Cache userOnlineCache = null;
    private static int userOnlineLimit = -1;
    private static int initOnlineLimit = -1;

    static {
        try {
            plantId = Integer.parseInt(Property.getProperty(0, "INTSERV_PLANT_ID"));
            String sOnlineLimit = Property.getProperty(0, "USER_ONLINE_LIMIT");
            if (sOnlineLimit != null && !"".equals(sOnlineLimit)) {
                initOnlineLimit = userOnlineLimit = Integer.parseInt(sOnlineLimit);
                CacheManager cacheManager = CacheManager.getInstance();
                cacheManager.removeCache("intserv.basic.auth.UserOnlineCache");
                CacheConfiguration config = new CacheConfiguration("intserv.basic.auth.UserOnlineCache", userOnlineLimit);
                config.setEternal(false);
                config.setTimeToIdleSeconds(600L);
                config.setTimeToLiveSeconds(7200L);
                cacheManager.addCache(new Cache(config));
                userOnlineCache = cacheManager.getCache("intserv.basic.auth.UserOnlineCache");
                userOnlineCache.removeAll();
                UserOnline.getServerAddrPort();
                UserOnline.resetOnlineLimit();
                UserOnlineThread thread = new UserOnlineThread();
                thread.start();
                log.info("userOnlineCache start with " + userOnlineLimit);
            }
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    protected static void resetOnlineLimit() {
        try {
            int cnt = PlantAccessClient.getOnlineLimit(plantId, serverAddr, serverPort);
            if (cnt >= 0 && cnt < initOnlineLimit && cnt != userOnlineLimit) {
                log.info("online limit set to " + cnt);
                userOnlineLimit = cnt;
            }
        }
        catch (Exception e) {
            log.error((Object)(String.valueOf(plantId) + "," + serverAddr + "," + serverPort), e);
        }
    }

    public static int visitCacheValue(String userId) {
        if (userOnlineCache == null) {
            return 0;
        }
        Element elem = userOnlineCache.get((Serializable)((Object)userId));
        if (elem == null) {
            if (userOnlineCache.getSize() >= userOnlineLimit) {
                return 1;
            }
            userOnlineCache.put(new Element((Serializable)((Object)userId), (Serializable)new Date()));
        }
        return 0;
    }

    public static void removeCacheValue(String userId) {
        if (userOnlineCache == null) {
            return;
        }
        userOnlineCache.remove((Serializable)((Object)userId));
    }

    protected static int getCacheSize() {
        if (userOnlineCache == null) {
            return -1;
        }
        userOnlineCache.evictExpiredElements();
        return userOnlineCache.getSize();
    }

    protected static void log() {
        int size = userOnlineCache.getSize();
        log.info("online user size(" + serverAddr + ":" + serverPort + ") = " + size);
        try {
            PlantAccessClient.saveOnlineCount(plantId, serverAddr, serverPort, size);
        }
        catch (Exception e) {
            log.error((Object)(String.valueOf(plantId) + "," + serverAddr + "," + serverPort + "," + size), e);
        }
    }

    private static void getServerAddrPort() {
        try {
            InitialContext ctx = new InitialContext();
            MBeanServer mBeanServer = (MBeanServer)ctx.lookup("java:comp/env/jmx/runtime");
            ObjectName objectName = new ObjectName("com.bea:Name=RuntimeService,Type=weblogic.management.mbeanservers.runtime.RuntimeServiceMBean");
            ObjectName runtime = (ObjectName)mBeanServer.getAttribute(objectName, "ServerRuntime");
            String listenPort = String.valueOf(mBeanServer.getAttribute(runtime, "ListenPort"));
            String listenAddr = (String)mBeanServer.getAttribute(runtime, "ListenAddress");
            String[] tempAddr = listenAddr.split("/");
            if (tempAddr.length == 1) {
                listenAddr = tempAddr[0];
            } else if (tempAddr[tempAddr.length - 1].trim().length() != 0) {
                listenAddr = tempAddr[tempAddr.length - 1];
            } else if (tempAddr.length > 2) {
                listenAddr = tempAddr[tempAddr.length - 2];
            }
            serverAddr = listenAddr;
            serverPort = listenPort;
        }
        catch (Exception e) {
            log.error(e);
            serverAddr = "0";
            serverPort = "0";
        }
        log.info("server start at " + serverAddr + ":" + serverPort);
    }
}

