/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.auth.login;

import com.cntaiping.intserv.basic.auth.employee.EmployeeArchClient;
import com.cntaiping.intserv.basic.auth.employee.ISBankAgent;
import com.cntaiping.intserv.basic.auth.login.ISLogin;
import com.cntaiping.intserv.basic.auth.user.ISUser;
import com.cntaiping.intserv.basic.auth.user.UserAccessClient;
import com.cntaiping.intserv.basic.auth.user.UserManageClient;
import com.cntaiping.intserv.basic.runtime.Property;
import com.cntaiping.intserv.basic.util.Tools;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import com.cntaiping.intserv.basic.util.security.ConvertPassword;
import com.cntaiping.intserv.basic.util.web.WebTools;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UserSecurityServlet
extends HttpServlet {
    private static Log logger = LogFactory.getLog(UserSecurityServlet.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sAction = request.getParameter("sAction");
        try {
            if ("toCrossDayModify".equals(sAction)) {
                this.toCrossDayModify(request, response);
            } else if ("doCrossDayModify".equals(sAction)) {
                this.doCrossDayModify(request, response);
            } else if ("toChooseTellerInfo".equals(sAction)) {
                this.toChooseTellerInfo(request, response);
            } else if ("getBankCodeList".equals(sAction)) {
                this.getBankCodeList(request, response);
            } else if ("checkTeller".equals(sAction)) {
                this.checkTeller(request, response);
            } else if ("doSaveBankEmp".equals(sAction)) {
                this.doSaveBankEmp(request, response);
            }
        }
        catch (Exception e) {
            logger.error(e);
            e.printStackTrace();
        }
    }

    public void toCrossDayModify(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String facade = Property.getProperty(0, "INTSERV_FACADE", "default");
        String remindType = request.getParameter("is_remind");
        String forwardUrl = "/intserv/facade/" + facade + "/password_cross_modify.jsp";
        String userName = Tools.toString(request.getParameter("userName"));
        ISUser isUser = UserAccessClient.getUserModel(userName);
        if ("first_login".equals(remindType)) {
            request.setAttribute("message", (Object)"\u8be5\u7528\u6237\u662f\u9996\u6b21\u767b\u5f55\uff0c\u4e0d\u80fd\u4f7f\u7528\u9ed8\u8ba4\u5bc6\u7801\uff0c\u8bf7\u4fee\u6539\u5bc6\u7801\uff01");
        } else if ("remind_day".equals(remindType)) {
            request.setAttribute("message", (Object)"\u8be5\u7528\u6237\u7684\u5bc6\u7801\u5df2\u7ecf\u8fc7\u671f\u4e86\uff0c\u8bf7\u5c3d\u5feb\u66f4\u6539\u5bc6\u7801\uff01");
        } else {
            request.setAttribute("message", (Object)("\u8be5\u7528\u6237\u7684\u5bc6\u7801\u8fd8\u6709" + request.getParameter("effDay") + "\u5929\u5c06\u8fc7\u671f\uff0c\u8bf7\u5c3d\u5feb\u66f4\u6539\u5bc6\u7801\uff01"));
        }
        String loginForwardUrl = "";
        String result = UserSecurityServlet.isChooseTellerInfo(request, userName, isUser.getPassword());
        if (!"".equals(result)) {
            loginForwardUrl = "intserv/facade/" + facade + "/index.jsp?" + result;
        } else {
            loginForwardUrl = "intserv/facade/" + facade + "/main.jsp";
            ISLogin.login(request, isUser.getUserName(), isUser.getPassword());
        }
        request.setAttribute("userVo", (Object)isUser);
        request.setAttribute("loginForwardUrl", (Object)loginForwardUrl);
        request.setAttribute("is_remind", (Object)request.getParameter("is_remind"));
        request.getRequestDispatcher(forwardUrl).forward((ServletRequest)request, (ServletResponse)response);
    }

    public void doCrossDayModify(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String facade = Property.getProperty(0, "INTSERV_FACADE", "default");
        String forwardUrl = "/intserv/facade/" + facade + "/password_cross_modify.jsp";
        String loginForwardUrl = "";
        try {
            String userName = this.getParam(request, "userName", 0);
            String userNewPwd = this.getParam(request, "userNewPwd", 0);
            ISUser isUser = UserAccessClient.getUserModel(userName);
            request.setAttribute("userVo", (Object)isUser);
            String oldPwd = "";
            oldPwd = "1".equals(isUser.getEncryption()) ? isUser.getPassword() : ConvertPassword.digestPassword(isUser.getPassword(), isUser.getUserCate(), isUser.getRawStaffId());
            request.setAttribute("is_remind", (Object)request.getParameter("is_remind"));
            if ("101".equals(isUser.getUserCate()) || "107".equals(isUser.getUserCate())) {
                ISUser isUser1 = UserManageClient.getISUser(Tools.toInteger(isUser.getUserId()));
                oldPwd = isUser1.getPassword();
            }
            UserManageClient.changPassword(Tools.toInteger(isUser.getUserId()), oldPwd, userNewPwd);
            UserAccessClient.updateUser("is_first_login", "0", isUser.getUserId());
            userNewPwd = ConvertPassword.digestPassword(userNewPwd, isUser.getUserCate(), isUser.getRawStaffId());
            String result = UserSecurityServlet.isChooseTellerInfo(request, userName, userNewPwd);
            if (!"".equals(result)) {
                loginForwardUrl = "intserv/facade/" + facade + "/index.jsp?" + result;
            } else {
                loginForwardUrl = "intserv/facade/" + facade + "/main.jsp";
                ISLogin.login(request, isUser.getUserName(), userNewPwd);
            }
            request.setAttribute("loginForwardUrl", (Object)loginForwardUrl);
            request.setAttribute("message", (Object)"\u4fee\u6539\u5bc6\u7801\u6210\u529f\u3002");
            request.setAttribute("toParent", (Object)"yes");
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorStr = "change user password failed: ";
            String message = "";
            message = (String.valueOf(errorStr) + "no user").equals(e.getMessage()) ? "\u6ca1\u6709\u6b64\u7528\u6237" : ((String.valueOf(errorStr) + "old password error").equals(e.getMessage()) ? "\u539f\u5bc6\u7801\u8f93\u5165\u9519\u8bef" : ((String.valueOf(errorStr) + "new password error").equals(e.getMessage()) ? "\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u539f\u5bc6\u7801\u4e00\u6837" : ((String.valueOf(errorStr) + "cannot find user for password change.").equals(e.getMessage()) ? "\u5bc6\u7801\u4fee\u6539\u5931\u8d25" : ((String.valueOf(errorStr) + "password length not enough.").equals(e.getMessage()) ? "\u5bc6\u7801\u957f\u5ea6\u9519\u8bef" : ((String.valueOf(errorStr) + "password must contain three options.").equals(e.getMessage()) ? "\u5bc6\u7801\u5fc5\u987b\u5305\u542b\u5927\u5199\u5b57\u6bcd\uff0c\u5c0f\u5199\u5b57\u6bcd\uff0c\u6570\u5b57\uff0c\u7279\u6b8a\u5b57\u7b26\u56db\u9879\u4e2d\u7684\u4e09\u9879" : e.getMessage().toString())))));
            request.setAttribute("message", (Object)message);
        }
        request.getRequestDispatcher(forwardUrl).forward((ServletRequest)request, (ServletResponse)response);
    }

    public static String isChooseTellerInfo(HttpServletRequest request, String userName, String password) throws Exception {
        ISUser isUser = UserAccessClient.getUserModel(userName);
        String sysNo = Property.getProperty(0, "INTSERV_PLANT_ID");
        String str = "";
        if ("2".equals(sysNo) || "3".equals(sysNo)) {
            if ("102".equals(isUser.getUserCate())) {
                str = "is_choose_teller_info=true&userName=" + userName + "&password=" + password;
            } else if (!("101".equals(isUser.getUserCate()) && "2".equals(sysNo) || "105".equals(isUser.getUserCate()))) {
                str = "is_loginMsg=userCateError";
            }
        }
        return str;
    }

    public String getParam(HttpServletRequest request, String param, int mode) {
        String value = Tools.nullToBlank(request.getParameter(param));
        if (mode == 0) {
            request.setAttribute(param, (Object)value);
        } else if (mode == 1) {
            request.getSession().setAttribute(param, (Object)value);
        }
        return value;
    }

    public void toChooseTellerInfo(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String facade = Property.getProperty(0, "INTSERV_FACADE", "default");
        String forwardUrl = "/intserv/facade/" + facade + "/choose_teller_info.jsp";
        String userName = request.getParameter("userName");
        String password = request.getParameter("password");
        ISUser user = UserAccessClient.getUserModel(userName);
        String agentId = Tools.toString(user.getRawStaffId());
        ISBankAgent agent = EmployeeArchClient.getAgentInfo(agentId);
        request.getSession().setAttribute("bankAgentInfo", (Object)agent);
        request.setAttribute("userName", (Object)userName);
        request.setAttribute("password", (Object)password);
        request.getRequestDispatcher(forwardUrl).forward((ServletRequest)request, (ServletResponse)response);
    }

    public void getBankCodeList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ISBankAgent agent = (ISBankAgent)request.getSession().getAttribute("bankAgentInfo");
        Map bankCodeMap = agent.getBankCodeMap();
        String bank = Tools.toString(request.getParameter("bank"));
        List bankCodeList = (List)bankCodeMap.get(bank);
        String returnStr = WebTools.getOptions(bankCodeList, "bankCode", "bankName", "", "Y", false);
        request.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=GBK");
        PrintWriter out = response.getWriter();
        out.print(returnStr);
        out.flush();
        out.close();
    }

    public void checkTeller(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean flag = false;
        ISBankAgent agent = (ISBankAgent)request.getSession().getAttribute("bankAgentInfo");
        Map tellerMap = agent.getTellerMap();
        String teller = Tools.toString(request.getParameter("teller"));
        String bankCode = Tools.toString(request.getParameter("bankCode"));
        List tellerList = (List)tellerMap.get(bankCode);
        int i = 0;
        while (i < tellerList.size()) {
            Map tMap = (Map)tellerList.get(i);
            if (tMap.get("internalCode").equals(teller)) {
                flag = true;
                return;
            }
            ++i;
        }
        request.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=GBK");
        PrintWriter out = response.getWriter();
        out.print(flag);
        out.flush();
        out.close();
    }

    public void doSaveBankEmp(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String facade = Property.getProperty(0, "INTSERV_FACADE", "default");
        String forwardUrl = "/intserv/facade/" + facade + "/choose_teller_info.jsp";
        String userName = request.getParameter("userName");
        String password = request.getParameter("password");
        ISLogin.login(request, userName, password);
        request.getRequestDispatcher(forwardUrl).forward((ServletRequest)request, (ServletResponse)response);
    }
}

