/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.auth.user;

import com.cntaiping.intserv.basic.auth.secure.Operator;
import com.cntaiping.intserv.basic.auth.secure.UserTraceBean;
import com.cntaiping.intserv.basic.auth.user.ISUser;
import com.cntaiping.intserv.basic.auth.user.ISUserBO;
import com.cntaiping.intserv.basic.auth.user.PasswordConfig;
import com.cntaiping.intserv.basic.auth.user.UserAccessConfig;
import com.cntaiping.intserv.basic.auth.user.UserInfoAtom;
import com.cntaiping.intserv.basic.auth.user.UserPasswordAtom;
import com.cntaiping.intserv.basic.auth.user.UserStatusAtom;
import com.cntaiping.intserv.basic.auth.user.UserTokenAtom;
import com.cntaiping.intserv.basic.auth.user.remote.ExtUserAccessClient;
import com.cntaiping.intserv.basic.runtime.db.DBUtil;
import com.cntaiping.intserv.basic.runtime.db.DBUtilExt;
import com.cntaiping.intserv.basic.runtime.db.FetchUtil;
import com.cntaiping.intserv.basic.runtime.db.Sysdate;
import com.cntaiping.intserv.basic.runtime.db.Trans;
import com.cntaiping.intserv.basic.util.Tools;
import com.cntaiping.intserv.basic.util.exception.AppException;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import com.cntaiping.intserv.basic.util.security.MsgDigest;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.UserTransaction;

public class UserAccessBean {
    private static Log log = LogFactory.getLog(UserAccessBean.class);

    @Deprecated
    public static boolean checkURI(ISUser user, HttpServletRequest request) throws Exception {
        if (user == null) {
            return false;
        }
        Set set = user.getModuleUrlSet();
        String servletPath = request.getServletPath();
        String uri = request.getRequestURI();
        String url = request.getRequestURL().toString();
        return set.contains(servletPath) || set.contains(uri) || set.contains(url);
    }

    @Deprecated
    public static boolean validUserInfo(String userName, String password, String plantId) throws AppException {
        ISUser user;
        block9: {
            block8: {
                block7: {
                    log.info("userName:" + userName + ",password:" + password + ",plantId:" + plantId);
                    if (userName == null || password == null) {
                        return false;
                    }
                    try {
                        user = UserAccessBean.getISUserByName(userName);
                        if (user != null) break block7;
                        return false;
                    }
                    catch (Exception e) {
                        log.error(String.valueOf(userName) + "(" + plantId + ")\n" + e.getMessage());
                        log.info("verify failure\uff01");
                        e.printStackTrace();
                        throw new AppException(e.getMessage());
                    }
                }
                String verifyPlantId = FetchUtil.getIdxValue("select verify_plant_id from is_ac_user_cate where user_cate=?", user.getUserCate());
                log.info("start to verify\uff01");
                if (!"101".equals(verifyPlantId) && !"12".equals(verifyPlantId) && !"500".equals(verifyPlantId) || user.getRawStaffId() == null || "null".equals(user.getRawStaffId())) break block8;
                log.info("start to connect ExtUserAccessClient.verify\uff01");
                user = ExtUserAccessClient.verify((int)Tools.toInteger(verifyPlantId), (int)Tools.toInteger(user.getUserCate()), (long)Tools.toLong(user.getRawStaffId()), (String)password);
                return user != null;
            }
            if (!"Y".equals(user.getDisabled())) break block9;
            return false;
        }
        if (!password.equals(user.getPassword())) {
            return false;
        }
        log.info("verify success\uff01");
        return true;
    }

    @Deprecated
    protected static String verify(int plantId, String userName, String password, String plantSID, String loginIP) throws AppException {
        String string;
        String session_id;
        CallableStatement stmt;
        Connection conn;
        UserTransaction trans;
        block9: {
            if (userName == null || password == null) {
                return null;
            }
            trans = null;
            conn = null;
            stmt = null;
            trans = Trans.getUserTransaction();
            trans.begin();
            conn = DBUtil.getConnection();
            stmt = conn.prepareCall("{call pkg_is_user_access.p_verify(?,?,?,?,?,?,?)}");
            stmt.setInt(1, plantId);
            stmt.setString(2, userName);
            stmt.setString(3, password);
            stmt.setString(4, plantSID);
            stmt.setString(5, loginIP);
            stmt.registerOutParameter(6, 2);
            stmt.registerOutParameter(7, 12);
            stmt.executeUpdate();
            session_id = stmt.getString(6);
            if (session_id != null && !"".equals(session_id)) break block9;
            trans.rollback();
            DBUtil.close(null, stmt, conn);
            return null;
        }
        try {
            String token = stmt.getString(7);
            if (token == null || "".equals(token)) {
                token = MsgDigest.MD5encrypt(String.valueOf(plantId) + "," + userName + "," + Sysdate.now());
                DBUtilExt.update("update is_ac_session set auth_token=? where session_id=?", new String[]{token, session_id}, conn);
            }
            trans.commit();
            string = token;
        }
        catch (Exception e) {
            try {
                log.error(String.valueOf(userName) + "(" + plantSID + ")\n" + e.getMessage());
                e.printStackTrace();
                try {
                    trans.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new AppException(1001, "verify user acces failed: " + e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtil.close(null, stmt, conn);
                throw throwable;
            }
        }
        DBUtil.close(null, stmt, conn);
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static UserAccessConfig verify(String userName, String password, String plantSID, Operator oper) throws AppException {
        int operType = 4;
        if (userName == null) return null;
        if (password == null) {
            return null;
        }
        ISUser user = null;
        try {
            user = UserInfoAtom.getISUserByName((String)userName);
        }
        catch (Exception e) {
            throw new AppException(9999, e.getMessage());
        }
        if (user == null) {
            throw new AppException(1000, "userNotFound");
        }
        int userCate = Integer.parseInt(user.getUserCate());
        String userId = user.getUserId();
        int plantId = oper.getPlantId();
        boolean success = false;
        UserAccessConfig config = null;
        AppException appEx = null;
        try {
            UserTransaction trans = null;
            boolean isByOuter = UserAccessBean.isVerifyByOuter(userCate, user.getRawStaffId());
            String message = null;
            if (!isByOuter) {
                if (UserStatusAtom.isRevoked((String)userId)) {
                    throw new AppException(1001, "userRevoked");
                }
                if (userCate == 104 && "Y".equals(user.getPwdNeedChange())) {
                    throw new AppException(1005, "pwdNeedChange");
                }
                try {
                    trans = Trans.getUserTransaction();
                    trans.begin();
                    UserStatusAtom.beforeLogin((int)userCate, (String)userId, (String)userId);
                    trans.commit();
                }
                catch (Exception e) {
                    try {
                        trans.rollback();
                        throw e;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw e;
                }
                if (UserStatusAtom.isExpired((String)userId)) {
                    throw new AppException(1002, "userExpired");
                }
                if (UserStatusAtom.isLocked((String)userId)) {
                    throw new AppException(1003, "userLocked");
                }
            }
            boolean exception = false;
            try {
                success = UserAccessBean.verifyPassword(userName, password);
            }
            catch (AppException e) {
                success = false;
                exception = true;
                message = e.getMessage();
            }
            if (isByOuter) {
                config = UserPasswordAtom.getAccessConfig((String)userId);
                if (exception && userCate == 107) {
                    if ("10004".equals(message)) {
                        throw new AppException(1002, "userExpired");
                    }
                    if ("10005".equals(message)) {
                        throw new AppException(1003, "userLocked");
                    }
                    if (!"10007".equals(message)) throw new AppException(1004, "pwdIncorrect");
                    success = true;
                    config.setHintChange(1);
                    config.setHintDays(-1);
                } else {
                    if (exception && userCate == 101) {
                        if ("wrong password".equals(message)) {
                            throw new AppException(1004, "pwdIncorrect");
                        }
                        if (!"userNeedChang".equals(message)) throw new AppException(9999, message);
                        throw new AppException(1005, "pwdNeedChange");
                    }
                    if (exception && userCate == 109) {
                        if ("wrong password".equals(message)) {
                            throw new AppException(1004, "pwdIncorrect");
                        }
                        if (!"userNeedChang".equals(message)) throw new AppException(9999, message);
                        success = true;
                        config.setHintChange(1);
                        config.setHintDays(-1);
                    }
                }
                if (!success) {
                    throw new AppException(1004, "pwdIncorrect");
                }
            } else {
                try {
                    trans = Trans.getUserTransaction();
                    trans.begin();
                    UserStatusAtom.saveLogin((int)userCate, (String)userId, (int)(success ? 1 : 0), (String)oper.getIpAddr());
                    trans.commit();
                }
                catch (Exception e) {
                    try {
                        trans.rollback();
                        throw e;
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw e;
                }
                if (!success) throw new AppException(1004, "pwdIncorrect");
                config = UserPasswordAtom.getAccessConfig((String)userId);
                if (userCate == 104) {
                    config.setIsFirstLogin(0);
                    config.setHintChange(0);
                }
            }
            String token = "";
            try {
                trans = Trans.getUserTransaction();
                trans.begin();
                token = UserTokenAtom.createToken((int)plantId, (String)userName, (String)plantSID, (String)oper.getIpAddr());
                trans.commit();
            }
            catch (Exception e) {
                try {
                    trans.rollback();
                    throw e;
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                throw e;
            }
            if (token == null || "".equals(token)) {
                throw new AppException(1006, "sessionFailed");
            }
            config.setToken(token);
        }
        catch (AppException e) {
            log.error((Object)(String.valueOf(userName) + "," + password), e);
            success = false;
            appEx = e;
        }
        catch (Exception e) {
            log.error((Object)(String.valueOf(userName) + "," + password), e);
            e.printStackTrace();
            success = false;
            appEx = new AppException(9999, e.getMessage());
        }
        try {
            oper.setUserId(userId);
            if (!success) {
                if (appEx.getErrCode() == 1004) {
                    UserTraceBean.trace((String)userId, (int)operType, (int)2, null, (String)("\u7528\u6237\u767b\u5f55\u9a8c\u8bc1\u9a8c\u8bc1\u5931\u8d25," + appEx.getMessage()), (Operator)oper);
                    throw appEx;
                } else {
                    UserTraceBean.trace((String)userId, (int)operType, (int)4, null, (String)("\u7528\u6237\u767b\u5f55\u9a8c\u8bc1\u9a8c\u8bc1\u5931\u8d25," + appEx.getMessage()), (Operator)oper);
                }
                throw appEx;
            }
            UserTraceBean.trace((String)userId, (int)operType, (int)1, (String)"\u7528\u6237\u767b\u5f55\u9a8c\u8bc1\u6210\u529f", null, (Operator)oper);
            return config;
        }
        catch (AppException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)(String.valueOf(userName) + "," + password), e);
            throw new AppException(9999, e.getMessage());
        }
    }

    protected static ISUser getUserModel(int plantId, String token) throws AppException {
        String userName = null;
        try {
            userName = UserAccessBean.getUserNameByToken(token);
            ISUser user = UserAccessBean.getISUserByName(userName);
            user.setModuleList(UserAccessBean.getModuleList(userName, plantId));
            user.setModuleUrlSet(UserAccessBean.getModuleUrlSet(userName, plantId));
            return user;
        }
        catch (Exception e) {
            log.error(String.valueOf(token) + "(" + plantId + ")\n" + e.getMessage());
            e.printStackTrace();
            throw new AppException(1002, "get user model failed: " + e.getMessage());
        }
    }

    public static Map getUserModelB(int plantId, String token) throws AppException {
        HashMap<String, String> userMap = new HashMap<String, String>();
        try {
            ISUser isUser = UserAccessBean.getUserModel(plantId, token);
            userMap.put("userId", isUser.getUserId());
            userMap.put("userName", isUser.getUserName());
            userMap.put("realName", isUser.getRealName());
            userMap.put("password", isUser.getPassword());
            userMap.put("organId", isUser.getOrganId());
            String organName = FetchUtil.getIdxValue("select abbr_name from t_company_organ where organ_id=?", isUser.getOrganId());
            userMap.put("organName", organName);
        }
        catch (Exception e) {
            throw new AppException(1017, "getUserModelB failed: " + e.getMessage());
        }
        return userMap;
    }

    protected static String crossApply(int plantId, String token, int dstPlantId) throws AppException {
        String winkToken = null;
        UserTransaction trans = null;
        try {
            trans = Trans.getUserTransaction();
            trans.begin();
            winkToken = UserTokenAtom.createWinkToken((int)plantId, (String)token, (int)dstPlantId);
            trans.commit();
        }
        catch (Exception e) {
            log.error((Object)(String.valueOf(plantId) + "," + token + "," + dstPlantId), e);
            try {
                trans.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AppException(1003, "cross apply user acces failed: " + e.getMessage());
        }
        return winkToken;
    }

    protected static String crossVerify(int plantId, String winkToken) throws AppException {
        try {
            return UserTokenAtom.checkWinkToken((int)plantId, (String)winkToken);
        }
        catch (Exception e) {
            log.error((Object)(String.valueOf(plantId) + "," + winkToken), e);
            throw new AppException(1004, "cross verify user acces failed: " + e.getMessage());
        }
    }

    protected static void revoke(int plantId, String token) throws AppException {
        UserTransaction trans = null;
        try {
            trans = Trans.getUserTransaction();
            trans.begin();
            UserTokenAtom.destroyToken(null, (String)token);
            trans.commit();
        }
        catch (Exception e) {
            log.error((Object)(String.valueOf(plantId) + "," + token), e);
            try {
                trans.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AppException(1005, "revoke user token failed: " + e.getMessage());
        }
    }

    @Deprecated
    protected static String getUserNameByToken(String token) throws Exception {
        Map map = DBUtilExt.querySingle("select * from is_ac_user where user_id=(select user_id from is_ac_session where auth_token=?)", token);
        if (map != null && map.size() > 0) {
            return (String)map.get("userName");
        }
        return null;
    }

    protected static ISUser getISUserByName(String userName) throws AppException {
        try {
            return UserInfoAtom.getISUserByName((String)userName);
        }
        catch (Exception e) {
            log.error((Object)userName, e);
            throw new AppException(1010, "get passwordConfig model failed: " + e.getMessage());
        }
    }

    @Deprecated
    protected static ISUser getUserByUserId(String userId) throws AppException {
        try {
            return UserInfoAtom.getISUser((String)userId);
        }
        catch (Exception e) {
            log.error((Object)userId, e);
            throw new AppException(1010, "get passwordConfig model failed: " + e.getMessage());
        }
    }

    @Deprecated
    protected static PasswordConfig getPwdConfig(String sysNo) throws AppException {
        PasswordConfig passwordConfig = null;
        try {
            Map map = DBUtilExt.querySingle("select * from is_bank_password_config where sys_no=?", sysNo);
            if (map != null && map.size() > 0) {
                passwordConfig = new PasswordConfig();
                passwordConfig.setSysNo(sysNo);
                passwordConfig.setChangeTime(Tools.toString(map.get("changeTime")));
                passwordConfig.setComplexity(Tools.toString(map.get("complexity")));
                passwordConfig.setEncryption(Tools.toString(map.get("encryption")));
                passwordConfig.setErrorTimes(Tools.toString(map.get("errorTimes")));
                passwordConfig.setFailureTime(Tools.toString(map.get("failureTime")));
                passwordConfig.setMaximum(Tools.toString(map.get("maximum")));
                passwordConfig.setSessionTime(Tools.toString(map.get("sessionTime")));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new AppException(1010, "get passwordConfig model failed: " + e.getMessage());
        }
        return passwordConfig;
    }

    private static List getModuleList(String userName, int plantId) throws SQLException {
        String sql = "with v_role as (\n    select distinct role_id\n      from is_ac_user a,\n           is_ac_user_role b\n     where a.user_id = b.user_id\n       and a.user_name = ?\n),\nv_leaf as (\n  select distinct d.module_id,d.is_leaf\n    from is_ac_module d, is_ac_role_module e,v_role m\n    where d.module_id = e.module_id\n      and e.role_id = m.role_id\n      and d.is_leaf = 'Y'\n      and d.plant_id = ?\n),\nv_module_full as (\n  select distinct parent_id,module_id,module_name,url,view_order,is_leaf\n    from is_ac_module\n    start with module_id in (select module_id from v_leaf)\n    connect by module_id = prior parent_id\n  order by parent_id,view_order\n)\nselect level,parent_id,module_id,module_name,url,view_order list_order,is_leaf leaf\n  from v_module_full f\n  start with parent_id=0\n  connect by parent_id = prior module_id  order by parent_id,view_order\n";
        log.info(sql);
        List list = FetchUtil.getIdxCollection(sql, new String[]{userName, "" + plantId});
        return list;
    }

    private static Set getModuleUrlSet(String userName, int plantId) throws SQLException {
        String sql = "with v_role as (\n    select distinct role_id\n      from is_ac_user a,\n           is_ac_user_role b\n     where a.user_id = b.user_id\n       and a.user_name = ?\n),\nv_leaf as (\n  select distinct d.module_id,d.is_leaf\n    from is_ac_module d, is_ac_role_module e,v_role m\n    where d.module_id = e.module_id\n      and e.role_id = m.role_id\n      and d.is_leaf = 'Y'\n      and d.plant_id = ?\n)\nselect distinct u.url\n  from v_leaf, is_ac_module_url u\n  where v_leaf.module_id=u.module_id\n";
        log.info(sql);
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        HashSet<String> set = new HashSet<String>();
        try {
            conn = DBUtil.getConnection();
            pst = conn.prepareStatement(sql);
            pst.setString(1, userName);
            pst.setInt(2, plantId);
            rs = pst.executeQuery();
            while (rs.next()) {
                set.add(rs.getString("url"));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, pst, conn);
            throw throwable;
        }
        DBUtil.close(rs, pst, conn);
        return set;
    }

    @Deprecated
    public static void updateUser(String colum, String value, String userId) throws AppException {
        Connection conn = null;
        try {
            try {
                conn = DBUtil.getConnection();
                String sql = "update is_ac_user set " + colum + " = ? where user_id = ?";
                DBUtilExt.update(sql, new Object[]{value, userId});
            }
            catch (Exception e) {
                throw new AppException(1003, "update is_ac_user failed: " + e.getMessage());
            }
        }
        finally {
            DBUtil.close(null, null, conn);
        }
    }

    public static ISUserBO queryUserBO(String userId) throws AppException {
        ISUserBO user = null;
        try {
            user = UserInfoAtom.getISUserBO((String)userId);
        }
        catch (Exception e) {
            log.error((Object)userId, e);
            user = new ISUserBO();
            user.push(1028, "query ISUserBO failed:" + e.getMessage());
            user.pushMsg("query ISUserBO failed:" + e.getMessage());
        }
        return user;
    }

    public static List getUserInfoList(List userList) throws AppException {
        try {
            for (Map userMap : userList) {
                String userId = Tools.toString(userMap.get("userId"));
                String sql = " SELECT T.USER_ID, T.USER_NAME, T.REAL_NAME, T1.ABBR_NAME    FROM IS_AC_USER T, T_COMPANY_ORGAN T1                    WHERE T.ORGAN_ID = T1.ORGAN_ID AND T.USER_ID = ? ";
                Map resultMap = DBUtilExt.querySingle(sql, new String[]{userId});
                userMap.put("userName", resultMap.get("userName"));
                userMap.put("realName", resultMap.get("realName"));
                userMap.put("abbrName", resultMap.get("abbrName"));
            }
        }
        catch (Exception e) {
            throw new AppException(1003, "update getUserInfoList failed: " + e.getMessage());
        }
        return userList;
    }

    @Deprecated
    public static Map checkLogin(String userName, String password, String sysNo) throws AppException {
        HashMap<String, Object> msg = new HashMap<String, Object>();
        try {
            boolean success;
            ISUser isUser = UserAccessBean.getISUserByName(userName);
            if (isUser == null) {
                msg.put("result", "failure");
                msg.put("message", "loginIncorrect");
                return msg;
            }
            UserTransaction trans = null;
            int userCate = Integer.parseInt(isUser.getUserCate());
            String userId = isUser.getUserId();
            int plantId = Integer.parseInt(sysNo);
            String loginIP = "";
            boolean isByOuter = UserAccessBean.isVerifyByOuter(userCate, isUser.getRawStaffId());
            String message = null;
            if (!isByOuter) {
                if (UserStatusAtom.isRevoked((String)isUser.getUserId())) {
                    msg.put("result", "failure");
                    msg.put("message", "userDisabled");
                    return msg;
                }
                if (userCate == 104 && "Y".equals(isUser.getPwdNeedChange())) {
                    msg.put("result", "failure");
                    msg.put("message", "personalAuthDeny");
                    return msg;
                }
                try {
                    trans = Trans.getUserTransaction();
                    trans.begin();
                    UserStatusAtom.beforeLogin((int)userCate, (String)isUser.getUserId(), (String)isUser.getUserId());
                    trans.commit();
                }
                catch (Exception e) {
                    try {
                        trans.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw e;
                }
                if (UserStatusAtom.isExpired((String)isUser.getUserId())) {
                    msg.put("result", "no_login");
                    msg.put("message", "userEffday");
                    return msg;
                }
                if (UserStatusAtom.isLocked((String)isUser.getUserId())) {
                    msg.put("result", "no_login");
                    msg.put("message", "userLock");
                    return msg;
                }
            }
            boolean exception = false;
            try {
                success = UserAccessBean.validUserInfo(userName, password, "" + plantId);
                if (success) {
                    msg.put("result", "success");
                } else {
                    msg.put("result", "failure");
                    msg.put("message", "loginIncorrect");
                }
            }
            catch (AppException e) {
                success = false;
                exception = true;
                message = e.getMessage();
                msg.put("result", "failure");
            }
            if (isByOuter) {
                if (exception && userCate == 107) {
                    if ("10004".equals(message)) {
                        msg.put("message", "userEffday");
                    } else if ("10005".equals(message)) {
                        msg.put("message", "userLock");
                    } else if ("10007".equals(message)) {
                        msg.put("result", "success");
                        msg.put("message", "remind_day");
                    } else {
                        msg.put("message", "loginIncorrect");
                    }
                } else if (exception && userCate == 101) {
                    if ("wrong password".equals(message)) {
                        msg.put("message", "loginIncorrect");
                    } else if ("userNeedChang".equals(message)) {
                        msg.put("result", "success");
                        msg.put("message", "remind_day");
                    } else {
                        msg.put("message", message);
                    }
                } else if (exception && userCate == 109) {
                    if ("wrong password".equals(message)) {
                        msg.put("message", "loginIncorrect");
                    } else if ("userNeedChang".equals(message)) {
                        msg.put("result", "success");
                        msg.put("message", "remind_day");
                    } else {
                        msg.put("message", message);
                    }
                }
                return msg;
            }
            try {
                trans = Trans.getUserTransaction();
                trans.begin();
                UserStatusAtom.saveLogin((int)userCate, (String)isUser.getUserId(), (int)(success ? 1 : 0), (String)loginIP);
                trans.commit();
            }
            catch (Exception e) {
                try {
                    trans.rollback();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw e;
            }
            Operator oper = new Operator();
            oper.setUserId(isUser.getUserId());
            if (success) {
                UserTraceBean.trace((String)isUser.getUserId(), (int)4, (int)1, (String)"\u7528\u6237\u767b\u5f55\u9a8c\u8bc1\u6210\u529f", null, (Operator)oper);
            } else {
                UserTraceBean.trace((String)isUser.getUserId(), (int)4, (int)2, null, (String)"\u7528\u6237\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25", (Operator)oper);
            }
            if (success) {
                if (userCate != 104) {
                    int effDay = UserStatusAtom.getPwdAvailableDays((int)userCate, (String)isUser.getUserId());
                    if ("1".equals(Tools.toString(isUser.getIsFirstLogin()))) {
                        msg.put("message", "first_login");
                    } else if (effDay <= 0) {
                        msg.put("message", "remind_day");
                    } else if (effDay <= 3 && effDay > 0) {
                        msg.put("message", "cross_day");
                        msg.put("effDay", effDay);
                    }
                }
                if (plantId == 2 || plantId == 3) {
                    if (102 == userCate) {
                        msg.put("message", "choose_teller");
                    } else if (101 != userCate && 105 != userCate && (104 != userCate || plantId != 3)) {
                        msg.put("message", "userCateError");
                    }
                }
            }
            return msg;
        }
        catch (Exception e) {
            log.error((Object)(String.valueOf(userName) + "," + password), e);
            throw new AppException(1020, "deal loginError failed: " + e.getMessage());
        }
    }

    public static boolean checkPassword(String userId, String encPassword) throws Exception {
        return UserPasswordAtom.checkPassword((String)userId, (String)encPassword);
    }

    private static boolean isVerifyByOuter(int userCate, String rawStaffId) {
        if (userCate == 101) {
            if (rawStaffId != null && !"null".equals(rawStaffId)) {
                return true;
            }
        } else {
            if (userCate == 107) {
                return true;
            }
            if (userCate == 109) {
                return true;
            }
        }
        return false;
    }

    private static boolean verifyPassword(String userName, String encPassword) throws AppException {
        ISUser user;
        block7: {
            block6: {
                if (userName == null || encPassword == null) {
                    return false;
                }
                user = UserAccessBean.getISUserByName(userName);
                if (user != null) break block6;
                return false;
            }
            String verifyPlantId = FetchUtil.getIdxValue("select verify_plant_id from is_ac_user_cate where user_cate=?", user.getUserCate());
            if (!"101".equals(verifyPlantId) && !"12".equals(verifyPlantId) && !"500".equals(verifyPlantId) || user.getRawStaffId() == null || "null".equals(user.getRawStaffId())) break block7;
            log.debug("start to connect ExtUserAccessClient.verify!" + userName + "-------" + encPassword);
            user = ExtUserAccessClient.verify((int)Tools.toInteger(verifyPlantId), (int)Tools.toInteger(user.getUserCate()), (long)Tools.toLong(user.getRawStaffId()), (String)encPassword);
            return user != null;
        }
        try {
            return UserPasswordAtom.checkPassword((String)user.getUserId(), (String)encPassword);
        }
        catch (AppException e) {
            log.error((Object)userName, e);
            throw e;
        }
        catch (Exception e) {
            log.error((Object)userName, e);
            throw new AppException(9999, e.getMessage());
        }
    }

    public static UserAccessConfig crossVerify(int plantId, String winkToken, String plantSID, Operator oper) throws AppException {
        try {
            String token = UserTokenAtom.checkWinkToken((int)plantId, (String)winkToken);
            if (token == null) {
                throw new AppException(9999, "user token lost.");
            }
            String userId = UserTokenAtom.getUserIdByWink((int)plantId, (String)winkToken);
            UserAccessConfig config = UserPasswordAtom.getAccessConfig((String)userId);
            return config;
        }
        catch (Exception e) {
            log.error((Object)(String.valueOf(plantId) + "," + winkToken), e);
            throw new AppException(1004, "cross verify user acces failed: " + e.getMessage());
        }
    }

    public static void revoke(int plantId, String token, String plantSID, Operator oper) throws AppException {
        UserTransaction trans = null;
        try {
            trans = Trans.getUserTransaction();
            trans.begin();
            UserTokenAtom.destroyToken(null, (String)token);
            trans.commit();
        }
        catch (Exception e) {
            log.error((Object)(String.valueOf(plantId) + "," + token), e);
            try {
                trans.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AppException(1005, "revoke user token failed: " + e.getMessage());
        }
    }
}

