/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.remote;

import com.cntaiping.intserv.basic.remote.RemoteFactory;
import com.cntaiping.intserv.basic.runtime.Property;
import com.cntaiping.intserv.basic.runtime.plant.PlantAccessClient;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import com.cntaiping.intserv.basic.util.security.MsgDigest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.MDC;

public class CallHttpServlet {
    private static Log log = LogFactory.getLog(CallHttpServlet.class);
    private String UrlBase = null;
    private String Charset = "UTF-8";

    public CallHttpServlet(int plantId) {
        try {
            this.UrlBase = Property.getProperty(0, "REMOTE_URLBASE_" + plantId);
        }
        catch (Exception e) {
            log.error((Object)("plantId:" + plantId + "\n" + e.getMessage()), e);
        }
        try {
            if (this.UrlBase == null || "".equals(this.UrlBase)) {
                this.UrlBase = PlantAccessClient.getPlantUrlBase(plantId);
            }
        }
        catch (Exception e) {
            log.error((Object)("plantId:" + plantId + "\n" + e.getMessage()), e);
        }
    }

    public CallHttpServlet(int plantId, String charset) {
        try {
            if (charset != null && !"".equals(charset)) {
                this.Charset = charset;
            }
            this.UrlBase = Property.getProperty(0, "REMOTE_URLBASE_" + plantId);
        }
        catch (Exception e) {
            log.error((Object)("plantId:" + plantId + "\n" + e.getMessage()), e);
        }
        try {
            if (this.UrlBase == null || "".equals(this.UrlBase)) {
                this.UrlBase = PlantAccessClient.getPlantUrlBase(plantId);
            }
        }
        catch (Exception e) {
            log.error((Object)("plantId:" + plantId + "\n" + e.getMessage()), e);
        }
    }

    public CallHttpServlet(String bundleName, int plantId) {
        try {
            this.UrlBase = Property.getProperty(bundleName, "REMOTE_URLBASE_" + plantId);
        }
        catch (Exception e) {
            log.error((Object)("plantId:" + plantId + "\n" + e.getMessage()), e);
        }
        try {
            if (this.UrlBase == null || "".equals(this.UrlBase)) {
                this.UrlBase = RemoteFactory.getPlantUrlBase(bundleName, plantId);
            }
        }
        catch (Exception e) {
            log.error((Object)("plantId:" + plantId + "\n" + e.getMessage()), e);
        }
    }

    public CallHttpServlet(String bundleName, int plantId, String charset) {
        try {
            if (charset != null && !"".equals(charset)) {
                this.Charset = charset;
            }
            this.UrlBase = Property.getProperty(bundleName, "REMOTE_URLBASE_" + plantId);
        }
        catch (Exception e) {
            log.error((Object)("plantId:" + plantId + "\n" + e.getMessage()), e);
        }
        try {
            if (this.UrlBase == null || "".equals(this.UrlBase)) {
                this.UrlBase = RemoteFactory.getPlantUrlBase(bundleName, plantId);
            }
        }
        catch (Exception e) {
            log.error((Object)("plantId:" + plantId + "\n" + e.getMessage()), e);
        }
    }

    public boolean sendStrOfPost(String servlet, HashMap params, StringBuffer sResult) {
        StringBuffer content = new StringBuffer();
        try {
            for (Map.Entry entry : params.entrySet()) {
                String paraName = (String)entry.getKey();
                String paraValue = (String)entry.getValue();
                content.append(paraName);
                content.append("=");
                content.append(URLEncoder.encode(paraValue, this.Charset));
                content.append("&");
            }
            return this.sendStrOfPost(servlet, content.toString(), sResult);
        }
        catch (Exception e) {
            log.error((Object)(String.valueOf(this.UrlBase) + servlet + "\n" + params + "\n" + e.getMessage()), e);
            return false;
        }
    }

    public boolean sendStrOfPost(String servlet, String content, StringBuffer sResult) {
        boolean bResult;
        block31: {
            bResult = false;
            URL url = null;
            HttpURLConnection httpConnection = null;
            InputStream httpIS = null;
            BufferedReader httpReader = null;
            String remoteID = null;
            try {
                try {
                    url = new URL(String.valueOf(this.UrlBase) + servlet);
                    httpConnection = (HttpURLConnection)url.openConnection();
                    httpConnection.setRequestMethod("POST");
                    httpConnection.setDoOutput(true);
                    httpConnection.setUseCaches(false);
                    httpConnection.setRequestProperty("Content-Length", String.valueOf(content.getBytes().length));
                    httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    String requestID = (String)MDC.get((String)"RequestID");
                    String sessionID = (String)MDC.get((String)"SessionID");
                    if (requestID != null) {
                        try {
                            remoteID = MsgDigest.MD5encrypt(String.valueOf(requestID) + "," + System.currentTimeMillis() + "," + Math.random());
                            log.info("RemoteID=" + remoteID + " , Remote-Invoke-URL=" + url.toString());
                            httpConnection.setRequestProperty("Log4j-Request-ID", remoteID);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (sessionID != null) {
                        httpConnection.setRequestProperty("Log4j-Session-ID", sessionID);
                    }
                    PrintWriter out = null;
                    out = new PrintWriter(new OutputStreamWriter(httpConnection.getOutputStream(), this.Charset));
                    out.print(content);
                    out.flush();
                    out.close();
                    int responseCode = httpConnection.getResponseCode();
                    if (responseCode == 200) {
                        bResult = true;
                        httpIS = httpConnection.getInputStream();
                        httpReader = new BufferedReader(new InputStreamReader(httpIS, this.Charset));
                        String line = null;
                        while ((line = httpReader.readLine()) != null) {
                            if (sResult.length() > 0) {
                                sResult.append("\n");
                            }
                            sResult.append(line);
                        }
                    } else {
                        log.error("[URL][response][failure][code : " + responseCode + " ]");
                    }
                }
                catch (IOException e) {
                    log.error((Object)(String.valueOf(servlet) + "\n" + content + "\n" + "[CallHttpServlet]sendStrOfPost error"), e);
                    try {
                        if (httpReader != null) {
                            httpReader.close();
                        }
                        if (httpIS != null) {
                            httpIS.close();
                        }
                        if (httpConnection != null) {
                            httpConnection.disconnect();
                        }
                    }
                    catch (IOException e2) {
                        log.error((Object)"[CallHttpServlet]finally error", e2);
                    }
                    if (remoteID != null) {
                        log.info("RemoteID=" + remoteID + " , Remote-Invoke-End.");
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (httpReader != null) {
                        httpReader.close();
                    }
                    if (httpIS != null) {
                        httpIS.close();
                    }
                    if (httpConnection != null) {
                        httpConnection.disconnect();
                    }
                }
                catch (IOException e) {
                    log.error((Object)"[CallHttpServlet]finally error", e);
                }
                if (remoteID != null) {
                    log.info("RemoteID=" + remoteID + " , Remote-Invoke-End.");
                }
                throw throwable;
            }
            try {
                if (httpReader != null) {
                    httpReader.close();
                }
                if (httpIS != null) {
                    httpIS.close();
                }
                if (httpConnection != null) {
                    httpConnection.disconnect();
                }
            }
            catch (IOException e) {
                log.error((Object)"[CallHttpServlet]finally error", e);
            }
            if (remoteID != null) {
                log.info("RemoteID=" + remoteID + " , Remote-Invoke-End.");
            }
        }
        return bResult;
    }
}

