/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.remote;

import com.caucho.hessian.client.HessianProxyFactory;
import com.cntaiping.intserv.basic.auth.secure.Operator;
import com.cntaiping.intserv.basic.runtime.Property;
import com.cntaiping.intserv.basic.runtime.plant.PlantAccessClient;
import com.cntaiping.intserv.basic.util.Tools;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import java.lang.reflect.Method;
import org.apache.log4j.MDC;

public class RemoteFactory {
    private static Log log = LogFactory.getLog(RemoteFactory.class);
    private HessianProxyFactory factory = new HessianProxyFactory();
    private String UrlBase = null;
    private long timeout = 30L;

    public RemoteFactory() {
        try {
            this.UrlBase = Property.getProperty(0, "HESSIAN_URLBASE");
        }
        catch (Exception e) {
            log.error((Object)"default", e);
        }
        this._initTimeout();
    }

    public RemoteFactory(String plantAlias) {
        try {
            this.UrlBase = Property.getProperty(0, "HESSIAN_URLBASE_" + plantAlias);
        }
        catch (Exception e) {
            log.error((Object)("plantAlias:" + plantAlias), e);
        }
        this._initTimeout();
    }

    public RemoteFactory(int plantId) {
        try {
            this.UrlBase = Property.getProperty(0, "REMOTE_URLBASE_" + plantId);
            if (this.UrlBase == null || "".equals(this.UrlBase)) {
                this.UrlBase = PlantAccessClient.getPlantUrlBase(plantId);
            }
        }
        catch (Exception e) {
            log.error((Object)("plantId:" + plantId), e);
        }
        this._initTimeout();
    }

    public RemoteFactory(String bundleName, String plantAlias) {
        try {
            this.UrlBase = Property.getProperty(bundleName, "HESSIAN_URLBASE_" + plantAlias);
        }
        catch (Exception e) {
            log.error((Object)("plantAlias:" + plantAlias), e);
        }
        this._initTimeout();
    }

    public RemoteFactory(String bundleName, int plantId) {
        try {
            this.UrlBase = Property.getProperty(bundleName, "REMOTE_URLBASE_" + plantId);
            if (this.UrlBase == null || "".equals(this.UrlBase)) {
                this.UrlBase = RemoteFactory.getPlantUrlBase(bundleName, plantId);
            }
        }
        catch (Exception e) {
            log.error((Object)("plantId:" + plantId), e);
        }
        this._initTimeout();
    }

    public static String getPlantUrlBase(String bundleName, int plantId) throws Exception {
        String method = Property.getProperty(bundleName, "PLANT_URLBASE_METHOD");
        if (method == null || "".equals(method.trim())) {
            throw new Exception("PLANT_URLBASE_METHOD not define.");
        }
        String clsName = method.substring(0, method.lastIndexOf(".")).trim();
        String mtdName = method.substring(method.lastIndexOf(".") + 1);
        mtdName = mtdName.replaceAll("\\(.*\\).*", "").trim();
        Class<?> cls = Class.forName(clsName);
        Method mtd = cls.getMethod(mtdName, Integer.TYPE);
        return (String)mtd.invoke(null, new Integer(plantId));
    }

    private void _initTimeout() {
        try {
            String sTimeout = Property.getProperty(0, "HESSIAN_TIMEOUT_SECS");
            if (sTimeout != null && !"".equals(sTimeout)) {
                this.timeout = Integer.parseInt(sTimeout);
            }
        }
        catch (Exception e) {
            this.timeout = 30L;
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Object create(Class cls, String url) throws Exception {
        this.factory.setOverloadEnabled(true);
        if (this.timeout > 0L) {
            this.factory.setReadTimeout(this.timeout * 1000L);
        }
        String log4jRequestID = (String)MDC.get((String)"RequestID");
        String log4jSessionID = (String)MDC.get((String)"SessionID");
        if (log4jRequestID != null) {
            this.factory.setLog4jRequestID(log4jRequestID);
        }
        if (log4jSessionID != null) {
            this.factory.setLog4jSessionID(log4jSessionID);
        }
        return this.factory.create(cls, String.valueOf(this.UrlBase) + url);
    }

    public Object create(Class cls, String url, Operator oper) throws Exception {
        String sOper;
        this.factory.setOverloadEnabled(true);
        if (this.timeout > 0L) {
            this.factory.setReadTimeout(this.timeout * 1000L);
        }
        if ((sOper = this.encodeOperator(oper)) != null) {
            this.factory.setUserOperator(sOper);
        }
        String log4jRequestID = (String)MDC.get((String)"RequestID");
        String log4jSessionID = (String)MDC.get((String)"SessionID");
        if (log4jRequestID != null) {
            this.factory.setLog4jRequestID(log4jRequestID);
        }
        if (log4jSessionID != null) {
            this.factory.setLog4jSessionID(log4jSessionID);
        }
        return this.factory.create(cls, String.valueOf(this.UrlBase) + url);
    }

    private String encodeOperator(Operator oper) {
        StringBuffer buff = new StringBuffer();
        buff.append("U/").append(Tools.nullToBlank(oper.getUserId())).append(";");
        buff.append("T/").append(Tools.nullToBlank(oper.getAuthToken())).append(";");
        buff.append("IP/").append(Tools.nullToBlank(oper.getIpAddr())).append(";");
        buff.append("DT/").append(oper.getDeviceType() == null ? "" : oper.getDeviceType()).append(";");
        buff.append("DI/").append(Tools.nullToBlank(oper.getDeviceId())).append(";");
        buff.append("G/").append(Tools.nullToBlank(oper.getGeoXy())).append(";");
        buff.append("P/").append(oper.getPlantId() == null ? "" : oper.getPlantId());
        return buff.toString();
    }
}

