/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.remote;

import com.caucho.hessian.server.HessianServlet;
import com.cntaiping.intserv.basic.auth.secure.Operator;
import com.cntaiping.intserv.basic.auth.user.ISUser;
import com.cntaiping.intserv.basic.auth.user.UserAccessClient;
import com.cntaiping.intserv.basic.remote.RemoteUserCache;
import com.cntaiping.intserv.basic.util.Tools;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class RemoteServlet
extends HessianServlet {
    private static final long serialVersionUID = 5306798167582833409L;
    private static Log log = LogFactory.getLog(RemoteServlet.class);
    private Operator oper = null;

    protected boolean needCheckAuth() {
        return false;
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        this.oper = this.decodeOperator(req.getHeader("User-Operator"));
        if (this.needCheckAuth()) {
            if (this.oper == null) {
                throw new RuntimeException("User-Operator is null.");
            }
            try {
                ISUser user = RemoteUserCache.getISUser(String.valueOf(this.oper.getUserId()) + "/" + this.oper.getAuthToken());
                if (!UserAccessClient.checkURI(user, req)) {
                    throw new RuntimeException("No access permission.");
                }
            }
            catch (Exception e) {
                this.oper = null;
                log.debug((Object)this.oper.getAuthToken(), e);
                throw new RuntimeException(e);
            }
        }
        super.service(request, response);
    }

    public Operator getOperator() {
        return this.oper;
    }

    private Operator decodeOperator(String sOper) {
        if (sOper == null || "".equals(sOper)) {
            return null;
        }
        Operator oper = new Operator();
        String[] values = Tools.splitStrings(sOper, ";");
        if (values == null) {
            return null;
        }
        int i = 0;
        while (i < values.length) {
            if (values[i] != null) {
                if (values[i].startsWith("U/")) {
                    oper.setUserId(Tools.blankToNull(values[i].substring(2)));
                } else if (values[i].startsWith("T/")) {
                    oper.setAuthToken(Tools.blankToNull(values[i].substring(2)));
                } else if (values[i].startsWith("IP/")) {
                    oper.setIpAddr(Tools.blankToNull(values[i].substring(3)));
                } else if (values[i].startsWith("DT/")) {
                    oper.setDeviceType(Tools.blankToNull(values[i].substring(3)) == null ? null : Integer.valueOf(values[i].substring(3)));
                } else if (values[i].startsWith("DI/")) {
                    oper.setDeviceId(Tools.blankToNull(values[i].substring(3)));
                } else if (values[i].startsWith("G/")) {
                    oper.setGeoXy(Tools.blankToNull(values[i].substring(2)));
                } else if (values[i].startsWith("P/")) {
                    oper.setPlantId(Tools.blankToNull(values[i].substring(2)) == null ? null : Integer.valueOf(values[i].substring(2)));
                }
            }
            ++i;
        }
        return oper;
    }
}

