/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.remote;

import com.cntaiping.intserv.basic.auth.user.ISUser;
import com.cntaiping.intserv.basic.auth.user.UserAccessClient;
import com.cntaiping.intserv.basic.runtime.Property;
import com.cntaiping.intserv.basic.runtime.plant.Plant;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;

public class RemoteUserCache {
    private static Log log = LogFactory.getLog(RemoteUserCache.class);
    private static Cache userTokenCache = null;

    static {
        try {
            String sTokenLimit = Property.getProperty(0, "HESSIAN_TOKEN_LIMIT");
            if (sTokenLimit != null && !"".equals(sTokenLimit)) {
                int userTokenLimit = Integer.parseInt(sTokenLimit);
                CacheManager cacheManager = CacheManager.getInstance();
                cacheManager.removeCache("intserv.basic.remote.UserTokenCache");
                CacheConfiguration config = new CacheConfiguration("intserv.basic.remote.UserTokenCache", userTokenLimit);
                config.setEternal(false);
                config.setTimeToIdleSeconds(120L);
                config.setTimeToLiveSeconds(300L);
                cacheManager.addCache(new Cache(config));
                userTokenCache = cacheManager.getCache("intserv.basic.remote.UserTokenCache");
                userTokenCache.removeAll();
                log.info("userTokenCache inited.");
            }
        }
        catch (Exception e) {
            log.error((Object)"RemoteUserCache init failed", e);
        }
    }

    public static ISUser getISUser(String userToken) throws Exception {
        if (userTokenCache == null) {
            return null;
        }
        if (userToken == null) {
            return null;
        }
        Element elem = userTokenCache.get((Serializable)((Object)userToken));
        if (elem != null) {
            return (ISUser)elem.getObjectValue();
        }
        ISUser user = null;
        try {
            int pos = userToken.indexOf("/");
            String userId = userToken.substring(0, pos);
            String authToken = userToken.substring(pos + 1);
            user = UserAccessClient.getUserModel(Plant.getLocalId(), authToken);
            if (user == null) {
                throw new Exception("user not found.");
            }
        }
        catch (Exception e) {
            log.error((Object)userToken, e);
            throw e;
        }
        userTokenCache.put(new Element((Serializable)((Object)userToken), (Serializable)user));
        return user;
    }
}

