/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class Property {
    private static Properties sysProperty = null;
    private static Properties appProperty = null;
    private static String strSysPropFilePath = String.valueOf(Property.getRootPath()) + "/is_sys.properties";
    private static String strAppPropFilePath = String.valueOf(Property.getRootPath()) + "/is_app.properties";
    private static HashMap propertyMap = new HashMap();

    public static String getProperty(int intLevel, String key) throws IOException {
        return Property.getProperty(intLevel, key, "");
    }

    public static String getProperty(int intLevel, String key, String defaultValue) throws IOException {
        if (intLevel == 0) {
            if (sysProperty == null) {
                sysProperty = Property.getPropObjFromBundle("is_sys");
            }
            if (sysProperty == null) {
                sysProperty = Property.getPropObjFromFile(strSysPropFilePath);
            }
            return sysProperty.getProperty(key, defaultValue);
        }
        if (appProperty == null) {
            appProperty = Property.getPropObjFromBundle("is_app");
        }
        if (appProperty == null) {
            appProperty = Property.getPropObjFromFile(strAppPropFilePath);
        }
        return appProperty.getProperty(key, defaultValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties getPropObjFromFile(String filePath) throws IOException {
        Properties objProp = new Properties();
        File file = new File(filePath);
        FileInputStream inStream = null;
        try {
            try {
                inStream = new FileInputStream(file);
                objProp.load(inStream);
                return objProp;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (inStream == null) return objProp;
                ((InputStream)inStream).close();
                return objProp;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (inStream == null) return objProp;
                ((InputStream)inStream).close();
                return objProp;
            }
        }
        finally {
            if (inStream != null) {
                ((InputStream)inStream).close();
            }
        }
    }

    public static String getProperty(String bundleName, String key) throws IOException {
        return Property.getProperty(bundleName, key, "");
    }

    public static String getProperty(String bundleName, String key, String defaultValue) throws IOException {
        Properties prop = (Properties)propertyMap.get(bundleName);
        if (prop == null && (prop = Property.getPropObjFromBundle(bundleName)) != null) {
            propertyMap.put(bundleName, prop);
        }
        if (prop == null && (prop = Property.getPropObjFromFile(String.valueOf(Property.getRootPath()) + "/" + bundleName + ".properties")) != null) {
            propertyMap.put(bundleName, prop);
        }
        return prop.getProperty(key, defaultValue);
    }

    public static Properties getPropObjFromBundle(String bundleName) {
        Properties objProp = new Properties();
        PropertyResourceBundle bundle = (PropertyResourceBundle)PropertyResourceBundle.getBundle(bundleName);
        Enumeration<String> enm = bundle.getKeys();
        while (enm.hasMoreElements()) {
            String key = enm.nextElement();
            String value = bundle.getString(key);
            objProp.setProperty(key, value);
        }
        return objProp;
    }

    public static String getRootPath() {
        try {
            InitialContext ctx = new InitialContext();
            String file = (String)ctx.lookup("java:comp/env/intservConfigFile");
            if (file != null && !"".equals(file)) {
                return file;
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        String result = Property.class.getResource("Property.class").toString();
        int index = result.indexOf("/com/cntaiping/");
        if (index == -1) {
            index = result.indexOf("bin");
        }
        if ((result = result.substring(0, index)).startsWith("jar")) {
            result = result.substring(10);
        } else if (result.startsWith("file")) {
            result = result.substring(6);
        }
        return result;
    }
}

