/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.runtime.avenue;

import com.cntaiping.intserv.basic.runtime.Property;
import com.cntaiping.intserv.basic.runtime.avenue.SmtpAuthenticator;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class EMailSender {
    private static Log log = LogFactory.getLog(EMailSender.class);
    private String loggerName = null;
    private String fromAddr = null;
    private InternetAddress[] toAddress = null;
    private String title = null;
    private String content = null;
    private String contentType = null;
    private List attachFile = new ArrayList();

    public EMailSender() throws Exception {
        this.fromAddr = Property.getProperty(1, "MAIL_FROM_ADDR");
    }

    public EMailSender(String sFromAddr, String sFromName) {
        this.fromAddr = sFromAddr;
    }

    public void setLogger(String name) {
        this.loggerName = name;
    }

    public void setFrom(String sFromAddr, String sFromName) {
        this.fromAddr = sFromAddr;
    }

    public void setTo(ArrayList toList) {
        if (toList == null) {
            return;
        }
        this.toAddress = new InternetAddress[toList.size()];
        try {
            int i = 0;
            while (i < toList.size()) {
                this.toAddress[i] = new InternetAddress((String)toList.get(i));
                ++i;
            }
        }
        catch (AddressException e) {
            log.error((Object)e, this.loggerName);
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public void addAttaches(HashMap attachMap) {
        if (attachMap != null) {
            String[] fileNames = attachMap.keySet().toArray(new String[0]);
            int i = 0;
            while (i < fileNames.length) {
                this.attachFile.add(new HashMap<String, String>().put("FILE_NAME", fileNames[i]));
                ++i;
            }
        }
    }

    public void sendEMail(List addressList, String title, String content, List attachList) throws Exception {
        this.title = title;
        this.content = content;
        log.debug((Object)("address size:" + addressList.size()), this.loggerName);
        if (addressList.size() > 0) {
            this.toAddress = new InternetAddress[addressList.size()];
        }
        int i = 0;
        while (i < addressList.size()) {
            HashMap address = (HashMap)addressList.get(i);
            String name = (String)address.get("CUST_NAME");
            String email = (String)address.get("CUST_EMAIL");
            log.debug((Object)email, this.loggerName);
            this.toAddress[i] = new InternetAddress(email, name);
            ++i;
        }
        if (attachList != null) {
            i = 0;
            while (i < attachList.size()) {
                this.attachFile.add(new HashMap((HashMap)attachList.get(i)));
                ++i;
            }
        }
        this.send();
    }

    public void sendEMail(String content, List attachList) throws Exception {
        this.content = content;
        if (attachList != null) {
            int i = 0;
            while (i < attachList.size()) {
                this.attachFile.add(new HashMap((HashMap)attachList.get(i)));
                ++i;
            }
        }
        this.send();
    }

    private void send() throws Exception {
        try {
            log.debug((Object)"send():enter", this.loggerName);
            MimeMultipart multipart = new MimeMultipart();
            MimeMessage msg = null;
            Properties props = System.getProperties();
            props.put("mail.smtp.host", Property.getProperty(1, "MAIL_SMTP_HOST"));
            props.put("mail.smtp.port", Property.getProperty(1, "MAIL_SMTP_PORT"));
            Session session = null;
            String isMailSmtp = Property.getProperty(1, "MAIL_SMTP_AUTH");
            if ("true".equals(isMailSmtp)) {
                props.put("mail.smtp.auth", isMailSmtp);
                SmtpAuthenticator myauth = new SmtpAuthenticator(Property.getProperty(1, "MAIL_FROM_ADDR"), Property.getProperty(1, "MAIL_FROM_PWD"));
                session = Session.getInstance((Properties)props, (Authenticator)myauth);
            } else {
                session = Session.getInstance((Properties)props, null);
            }
            session.setDebug(false);
            msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(this.fromAddr));
            msg.setRecipients(Message.RecipientType.TO, (Address[])this.toAddress);
            msg.setSubject(this.title);
            MimeBodyPart mbp_text = new MimeBodyPart();
            if (this.contentType == null || "".equals(this.contentType)) {
                mbp_text.setText(this.content);
            } else {
                mbp_text.setContent((Object)this.content, this.contentType);
            }
            multipart.addBodyPart((BodyPart)mbp_text);
            int i = 0;
            while (i < this.attachFile.size()) {
                this.attachMail((Multipart)multipart, (String)((HashMap)this.attachFile.get(i)).get("FILE_NAME"));
                ++i;
            }
            msg.setContent((Multipart)multipart);
            msg.setSentDate(new Date());
            log.debug((Object)"send():send", this.loggerName);
            Transport.send((Message)msg);
            multipart = null;
            log.debug((Object)"send():leave", this.loggerName);
        }
        catch (Exception e) {
            log.error((Object)e, this.loggerName);
            throw e;
        }
    }

    private void attachMail(Multipart multipart, String fileName) throws Exception {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        FileDataSource fds = new FileDataSource(fileName);
        mimeBodyPart.setDataHandler(new DataHandler((DataSource)fds));
        mimeBodyPart.setFileName(fds.getName());
        mimeBodyPart.setHeader("Content-Transfer-Encoding", "base64");
        multipart.addBodyPart((BodyPart)mimeBodyPart);
        log.debug((Object)("attach file " + fds.getName()), this.loggerName);
    }
}

