/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.runtime.avenue;

import com.cntaiping.intserv.basic.util.FileTools;
import com.cntaiping.intserv.basic.util.Tools;
import com.cntaiping.intserv.basic.util.XMLTools;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.List;
import org.dom4j.Element;

public class FtpSender {
    private static Log log = LogFactory.getLog(FtpSender.class);
    public static final int ASCII = 1;
    public static final int BINARY = 2;
    private String host = null;
    private int port = 21;
    private String userName = null;
    private String password = null;
    private String initPath = "/";
    private String fileSeparator = "/";
    private int transferType = 0;
    FTPClient ftp = null;

    public FtpSender(String ftpName) throws Exception {
        Element config = XMLTools.ElementRoot(FileTools.toString("ftp.xml", null));
        List list = config.elements("FTP");
        int i = 0;
        while (i < list.size()) {
            Element ftp = (Element)list.get(i);
            if (ftpName.equals(ftp.elementTextTrim("NAME"))) {
                this.host = ftp.elementTextTrim("HOST");
                if (ftp.elementTextTrim("PORT") != null && !"".equals(ftp.elementTextTrim("PORT"))) {
                    this.port = Integer.parseInt(ftp.elementTextTrim("PORT"));
                }
                this.userName = ftp.elementTextTrim("USERNAME");
                this.password = ftp.elementTextTrim("PASSWORD");
                if (ftp.elementTextTrim("PATH") != null && !"".equals(ftp.elementTextTrim("PATH"))) {
                    this.initPath = ftp.elementTextTrim("PATH");
                    if (!this.initPath.endsWith("/")) {
                        this.initPath = String.valueOf(this.initPath) + "/";
                    }
                }
                if ("ASCII".equals(ftp.elementTextTrim("TRANSFER_TYPE"))) {
                    this.transferType = 1;
                } else if ("BINARY".equals(ftp.elementTextTrim("TRANSFER_TYPE"))) {
                    this.transferType = 2;
                }
            }
            ++i;
        }
    }

    public void upload(InputStream inStream, String fileName, String filePath) throws Exception {
        try {
            log.info("start ftp://" + this.host + ":" + this.port);
            this.ftp = new FTPClient(this.host, this.port);
            this.ftp.login(this.userName, this.password);
            switch (this.transferType) {
                case 1: {
                    this.ftp.setType(FTPTransferType.ASCII);
                    break;
                }
                case 2: {
                    this.ftp.setType(FTPTransferType.BINARY);
                }
            }
            String path = this.chdirForce(filePath);
            log.info("ftp chdir " + path);
            this.ftp.put(inStream, String.valueOf(path) + fileName);
            log.info("ftp upload " + fileName);
        }
        finally {
            try {
                if (this.ftp != null) {
                    this.ftp.quit();
                }
            }
            catch (Exception exception) {}
            this.ftp = null;
        }
    }

    public void upload(String inText, String fileName, String filePath) throws Exception {
        StringBufferInputStream inStream = new StringBufferInputStream(inText);
        this.upload(inStream, fileName, filePath);
    }

    private boolean isExist(String path) {
        try {
            this.ftp.chdir(path);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String chdirForce(String filePath) throws Exception {
        String path = null;
        path = filePath == null || "".equals(filePath) ? this.initPath : (!filePath.startsWith("/") ? String.valueOf(this.initPath) + filePath : filePath);
        if (this.isExist(path)) {
            this.ftp.chdir(path);
        } else {
            String[] subPath = Tools.splitStrings(path, this.fileSeparator);
            this.ftp.chdir(this.fileSeparator);
            int i = 1;
            while (i < subPath.length) {
                if (!this.isExist(subPath[i])) {
                    this.ftp.mkdir(subPath[i]);
                }
                ++i;
            }
        }
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        return path;
    }
}

