/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.runtime.avenue;

import com.cntaiping.intserv.basic.runtime.Property;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import com.cntaiping.sms.net.rmi.TPSmsMessages;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class MessageSender {
    private static Log log = LogFactory.getLog(MessageSender.class);
    private static String userName = null;
    private static String password = null;
    private static String fromId = null;
    private String orgId = Property.getProperty(0, "SMS_ORG_ID", "");
    private String channelId = null;
    private String branchId = null;
    private String serviceId = null;
    private String[] toAddress = null;
    private String msgId = null;
    private String[] msgIds = null;
    private String content = null;

    static {
        try {
            userName = Property.getProperty(0, "SMS_USERNAME", "");
            password = Property.getProperty(0, "SMS_PASSWORD", "");
            fromId = Property.getProperty(0, "SMS_FROM_ID", "");
        }
        catch (Exception e) {
            log.error((Object)"init property failed!", e);
        }
    }

    public void setVendor(String channel, String service, String organId) {
        this.channelId = channel;
        if ("CHANNEL_GX".equals(channel) || "CHANNEL_YB".equals(channel) || "CHANNEL_DY".equals(channel) || "CHANNEL_XQ".equals(channel)) {
            this.orgId = "ORG_TPRS";
        }
        this.branchId = organId;
        this.serviceId = service;
    }

    public void sendMsg(List addressList, String content) throws Exception {
        this.content = content;
        log.debug("address size:" + addressList.size());
        if (addressList.size() > 0) {
            this.toAddress = new String[addressList.size()];
            this.msgIds = new String[addressList.size()];
        }
        int i = 0;
        while (i < addressList.size()) {
            HashMap address = (HashMap)addressList.get(i);
            String mp = (String)address.get("CUST_MP");
            String id = (String)address.get("SEND_ID");
            log.debug(mp);
            this.toAddress[i] = mp;
            this.msgIds[i] = id;
            ++i;
        }
        this.send();
    }

    public void sendMsg(List addressList, String content, String id) throws Exception {
        this.content = content;
        this.msgId = id;
        log.debug("address size:" + addressList.size());
        if (addressList.size() > 0) {
            this.toAddress = new String[addressList.size()];
        }
        int i = 0;
        while (i < addressList.size()) {
            HashMap address = (HashMap)addressList.get(i);
            String mp = (String)address.get("CUST_MP");
            log.debug(mp);
            this.toAddress[i] = mp;
            ++i;
        }
        this.send();
    }

    public void sendMsg(String[] toList, String content, String id) throws Exception {
        this.toAddress = toList;
        this.content = content;
        this.msgId = id;
        this.send();
    }

    public void sendMsg(String mp, String content, String id) throws Exception {
        this.toAddress = new String[]{mp};
        this.content = content;
        this.msgId = id;
        this.send();
    }

    private void send() throws Exception {
        try {
            if (this.content == null || "".equals(this.content)) {
                return;
            }
            TPSmsMessages msgs = new TPSmsMessages();
            msgs.setUsername(userName);
            msgs.setPassword(password);
            msgs.setFromID(fromId);
            msgs.setOrgID(this.orgId);
            msgs.setChannelID(this.channelId);
            msgs.setBranchID(this.branchId);
            msgs.setServiceID(this.serviceId);
            log.info("message vendor:" + this.channelId + "/" + this.branchId + "/" + this.serviceId);
            msgs.setIIP_ID(this.msgId);
            msgs.setLengthSMFLag("0");
            int i = 0;
            while (i < this.toAddress.length) {
                msgs.setReceiver(this.toAddress[i]);
                msgs.setContents(this.content);
                if (this.msgId == null && this.msgIds != null) {
                    msgs.setIIP_ID(this.msgIds[i]);
                }
                msgs.send();
                log.info("send to " + this.toAddress[i] + " message: " + this.content);
                ++i;
            }
        }
        catch (Exception e) {
            log.error((Object)"send message failed.", e);
            throw e;
        }
    }
}

