/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.runtime.casign;

import cn.org.bjca.anysign.client.security.SecurityEngineDeal;
import cn.org.bjca.anysign.model.AnywriteSignInfo;
import com.cntaiping.intserv.basic.runtime.casign.CAFile;
import com.cntaiping.intserv.basic.runtime.db.Sysdate;
import com.cntaiping.intserv.basic.util.Results;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Certification {
    private static Log log = LogFactory.getLog(Certification.class);
    public static SecurityEngineDeal sed = null;

    static {
        try {
            sed = SecurityEngineDeal.getInstance();
        }
        catch (Exception e) {
            log.error((Object)"SecurityEngineDeal init errror!", (Throwable)e);
        }
    }

    public static int sign(byte[] encData, String filePath, String fileName, String busiCate, String isAsy) throws Exception {
        int result = -1;
        if ("1".equals(isAsy)) {
            result = Certification.signASY(encData, filePath, fileName);
        } else if ("0".equals(isAsy)) {
            result = Certification.signSYN(encData, filePath, fileName);
        }
        return result;
    }

    public static Results verifyFile(byte[] file) throws Exception {
        Results verifyResult = new Results();
        try {
            int[] rv = new int[]{-1};
            String result = sed.verifyPDF(file, rv, "");
            verifyResult.setResultCode(rv[0]);
            if (rv[0] == 0) {
                verifyResult.setResultDesc(result);
            } else {
                verifyResult.setErrDesc(result);
            }
            log.info((Object)("rv :" + rv[0] + "; result :" + result + Sysdate.now()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("verifyFile failed: " + e.getMessage());
        }
        return verifyResult;
    }

    private static int signSYN(byte[] encData, String filePath, String fileName) throws Exception {
        int[] rv = new int[]{-1};
        byte[] signedValue = null;
        try {
            signedValue = sed.getPDFAnyWriteSign(encData, "", rv);
            log.info((Object)("CA response value=" + rv[0]));
            if (rv[0] == 0) {
                ByteArrayInputStream in = new ByteArrayInputStream(signedValue);
                try {
                    CAFile.writeCAFile(in, fileName, filePath);
                }
                catch (Exception e) {
                    log.error((Object)("write signed file error:" + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("SecurityEngine error:" + e));
            e.printStackTrace();
            throw new Exception("signSyn failed: " + e.getMessage());
        }
        return rv[0];
    }

    private static int signASY(byte[] encData, String filePath, String fileName) throws Exception {
        int[] rv = new int[]{-1};
        List signResult = null;
        try {
            ArrayList<AnywriteSignInfo> alist = new ArrayList<AnywriteSignInfo>();
            ArrayList<byte[]> dsByte = new ArrayList<byte[]>();
            dsByte.add(encData);
            AnywriteSignInfo asinfo = new AnywriteSignInfo();
            asinfo.setExtNote("");
            asinfo.setWoNo(fileName);
            asinfo.setDataSource(dsByte);
            asinfo.setInputPdfPath(filePath);
            alist.add(asinfo);
            signResult = sed.getPDFAnyWriteSignByObject(alist, rv);
            log.info((Object)("invoke result : " + rv[0]));
            if (signResult != null) {
                int a = 0;
                while (a < signResult.size()) {
                    System.out.println("result : " + new String((byte[])signResult.get(a)));
                    ++a;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("sign" + filePath + fileName + "failed:" + e.getMessage()));
            e.printStackTrace();
            throw new Exception("signAsy failed: " + e.getMessage());
        }
        return rv[0];
    }
}

