/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.runtime.db;

import com.cntaiping.intserv.basic.runtime.db.DBUtil;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class DBUtilExt {
    private static Log log = LogFactory.getLog(DBUtilExt.class);

    public static int update(String sql, Object[] params, Connection conn) throws SQLException {
        PreparedStatement pst = null;
        int rows = 0;
        try {
            try {
                pst = conn.prepareStatement(sql);
                if (params != null) {
                    int i = 0;
                    while (i < params.length) {
                        pst.setObject(i + 1, params[i]);
                        ++i;
                    }
                }
                rows = pst.executeUpdate();
            }
            catch (SQLException e) {
                log.error(String.valueOf(sql) + ":" + DBUtilExt.toString(params));
                throw e;
            }
        }
        finally {
            DBUtil.close(null, pst, null);
        }
        return rows;
    }

    public static int update(String sql, Object param, Connection conn) throws SQLException {
        if (param instanceof Object[]) {
            return DBUtilExt.update(sql, (Object[])param, conn);
        }
        return DBUtilExt.update(sql, new Object[]{param}, conn);
    }

    public static int update(String sql, Connection conn) throws SQLException {
        return DBUtilExt.update(sql, null, conn);
    }

    public static int update(String sql, Object[] params) throws SQLException {
        Connection conn = null;
        try {
            conn = DBUtil.getConnection();
            int n = DBUtilExt.update(sql, params, conn);
            return n;
        }
        finally {
            DBUtil.close(null, null, conn);
        }
    }

    public static int update(String sql, Object param) throws SQLException {
        Connection conn = null;
        try {
            conn = DBUtil.getConnection();
            int n = DBUtilExt.update(sql, param, conn);
            return n;
        }
        finally {
            DBUtil.close(null, null, conn);
        }
    }

    public static int update(String sql) throws SQLException {
        Connection conn = null;
        try {
            conn = DBUtil.getConnection();
            int n = DBUtilExt.update(sql, conn);
            return n;
        }
        finally {
            DBUtil.close(null, null, conn);
        }
    }

    public static List query(String sql, Object[] params, Connection conn) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        List list = null;
        try {
            try {
                pst = conn.prepareStatement(sql);
                if (params != null) {
                    int i = 0;
                    while (i < params.length) {
                        pst.setObject(i + 1, params[i]);
                        ++i;
                    }
                }
                rs = pst.executeQuery();
                list = DBUtil.resultSetToList(rs);
            }
            catch (SQLException e) {
                log.error(String.valueOf(sql) + ":" + DBUtilExt.toString(params));
                throw e;
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, pst, null);
            throw throwable;
        }
        DBUtil.close(rs, pst, null);
        return list;
    }

    public static List query(String sql, Object param, Connection conn) throws SQLException {
        if (param instanceof Object[]) {
            return DBUtilExt.query(sql, (Object[])param, conn);
        }
        return DBUtilExt.query(sql, new Object[]{param}, conn);
    }

    public static List query(String sql, Connection conn) throws SQLException {
        return DBUtilExt.query(sql, null, conn);
    }

    public static List query(String sql, Object[] params) throws SQLException {
        Connection conn = null;
        try {
            conn = DBUtil.getConnection();
            List list = DBUtilExt.query(sql, params, conn);
            return list;
        }
        finally {
            DBUtil.close(null, null, conn);
        }
    }

    public static List query(String sql, Object param) throws SQLException {
        Connection conn = null;
        try {
            conn = DBUtil.getConnection();
            List list = DBUtilExt.query(sql, param, conn);
            return list;
        }
        finally {
            DBUtil.close(null, null, conn);
        }
    }

    public static List query(String sql) throws SQLException {
        Connection conn = null;
        try {
            conn = DBUtil.getConnection();
            List list = DBUtilExt.query(sql, conn);
            return list;
        }
        finally {
            DBUtil.close(null, null, conn);
        }
    }

    public static Map querySingle(String sql, Object[] params, Connection conn) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        Map map = null;
        try {
            try {
                pst = conn.prepareStatement(sql);
                if (params != null) {
                    int i = 0;
                    while (i < params.length) {
                        pst.setObject(i + 1, params[i]);
                        ++i;
                    }
                }
                rs = pst.executeQuery();
                map = DBUtil.resultSetToMap(rs);
            }
            catch (SQLException e) {
                log.error(String.valueOf(sql) + ":" + DBUtilExt.toString(params));
                throw e;
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, pst, null);
            throw throwable;
        }
        DBUtil.close(rs, pst, null);
        return map;
    }

    public static Map querySingle(String sql, Object param, Connection conn) throws SQLException {
        if (param instanceof Object[]) {
            return DBUtilExt.querySingle(sql, (Object[])param, conn);
        }
        return DBUtilExt.querySingle(sql, new Object[]{param}, conn);
    }

    public static Map querySingle(String sql, Connection conn) throws SQLException {
        return DBUtilExt.querySingle(sql, null, conn);
    }

    public static Map querySingle(String sql, Object[] params) throws SQLException {
        Connection conn = null;
        try {
            conn = DBUtil.getConnection();
            Map map = DBUtilExt.querySingle(sql, params, conn);
            return map;
        }
        finally {
            DBUtil.close(null, null, conn);
        }
    }

    public static Map querySingle(String sql, Object param) throws SQLException {
        Connection conn = null;
        try {
            conn = DBUtil.getConnection();
            Map map = DBUtilExt.querySingle(sql, param, conn);
            return map;
        }
        finally {
            DBUtil.close(null, null, conn);
        }
    }

    public static Map querySingle(String sql) throws SQLException {
        Connection conn = null;
        try {
            conn = DBUtil.getConnection();
            Map map = DBUtilExt.querySingle(sql, conn);
            return map;
        }
        finally {
            DBUtil.close(null, null, conn);
        }
    }

    private static String toString(Object[] params) {
        if (params == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        if (params.length > 0) {
            buff.append(params[0]);
        }
        int i = 1;
        while (i < params.length) {
            buff.append(";").append(params[i]);
            ++i;
        }
        return buff.toString();
    }
}

