/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.runtime.db;

import com.cntaiping.intserv.basic.runtime.db.DBUtil;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

public class Sysdate {
    private static Log log = LogFactory.getLog(Sysdate.class);

    public static Timestamp now(Connection conn) throws SQLException {
        ResultSet rs;
        PreparedStatement pst;
        block4: {
            Timestamp timestamp;
            pst = null;
            rs = null;
            try {
                pst = conn.prepareStatement("select sysdate from dual");
                rs = pst.executeQuery();
                if (!rs.next()) break block4;
                timestamp = rs.getTimestamp(1);
            }
            catch (SQLException ex) {
                try {
                    log.error("select sysdate from dual");
                    throw ex;
                }
                catch (Throwable throwable) {
                    DBUtil.close(rs, pst, null);
                    throw throwable;
                }
            }
            DBUtil.close(rs, pst, null);
            return timestamp;
        }
        DBUtil.close(rs, pst, null);
        return null;
    }

    public static Timestamp now() throws SQLException {
        Connection conn = DBUtil.getConnection();
        try {
            Timestamp timestamp = Sysdate.now(conn);
            return timestamp;
        }
        finally {
            DBUtil.close(null, null, conn);
        }
    }

    public static String format(Timestamp time, String format) throws SQLException {
        if (time == null) {
            return null;
        }
        SimpleDateFormat df = null;
        try {
            df = new SimpleDateFormat(format);
        }
        catch (IllegalArgumentException lex) {
            df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return df.format(time);
    }

    public static String format(String format) throws SQLException {
        return Sysdate.format(Sysdate.now(), format);
    }

    public static String sNow(Connection conn) throws SQLException {
        return Sysdate.format(Sysdate.now(conn), "yyyy-MM-dd HH:mm:ss");
    }

    public static String sNow() throws SQLException {
        return Sysdate.format(Sysdate.now(), "yyyy-MM-dd HH:mm:ss");
    }

    public static String sDay(Connection conn) throws SQLException {
        return Sysdate.format(Sysdate.now(conn), "yyyy-MM-dd");
    }

    public static String sDay() throws SQLException {
        return Sysdate.format(Sysdate.now(), "yyyy-MM-dd");
    }
}

