/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.runtime.db.page;

import java.io.Serializable;

public class Page
implements Serializable {
    private static final long serialVersionUID = 2064844592531785899L;
    public static final Page EMPTY_PAGE = new Page();
    public static final int DEFAULT_PAGE_SIZE = 20;
    public static final int MAX_PAGE_SIZE = 9999;
    private int myPageSize = 20;
    private int start;
    private int avaCount;
    private int totalSize;
    private Object data;
    private int currentPageno;
    private int totalPageCount;

    protected Page() {
        this.init(0, 0, 0, 20, new Object());
    }

    protected void init(int start, int avaCount, int totalSize, int pageSize, Object data) {
        this.avaCount = avaCount;
        this.myPageSize = pageSize;
        this.start = start;
        this.totalSize = totalSize;
        this.data = data;
        this.currentPageno = (start - 1) / pageSize + 1;
        this.totalPageCount = (totalSize + pageSize - 1) / pageSize;
        if (totalSize == 0 && avaCount == 0) {
            this.currentPageno = 1;
            this.totalPageCount = 1;
        }
    }

    public Object getData() {
        return this.data;
    }

    public int getPageSize() {
        return this.myPageSize;
    }

    public boolean hasNextPage() {
        return this.getCurrentPageNo() < this.getTotalPageCount();
    }

    public boolean hasPreviousPage() {
        return this.getCurrentPageNo() > 1;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        int end = this.getStart() + this.getSize() - 1;
        if (end < 0) {
            end = 0;
        }
        return end;
    }

    public int getStartOfPreviousPage() {
        return Math.max(this.start - this.myPageSize, 1);
    }

    public int getStartOfNextPage() {
        return this.start + this.avaCount;
    }

    public static int getStartOfAnyPage(int pageNo) {
        return Page.getStartOfAnyPage(pageNo, 20);
    }

    public static int getStartOfAnyPage(int pageNo, int pageSize) {
        int startIndex = (pageNo - 1) * pageSize + 1;
        if (startIndex < 1) {
            startIndex = 1;
        }
        return startIndex;
    }

    public int getSize() {
        return this.avaCount;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public int getCurrentPageNo() {
        return this.currentPageno;
    }

    public int getTotalPageCount() {
        return this.totalPageCount;
    }

    public String getHTML() {
        return this.getHTML("gotoPage");
    }

    public String getHTML(String queryJSFunctionName) {
        return this.getHTML(queryJSFunctionName, "pageno");
    }

    public String getHTML(String queryJSFunctionName, String pageNoParamName) {
        if (this.getTotalPageCount() < 1) {
            return "<input type='hidden' name='" + pageNoParamName + "' value='1' >";
        }
        if (queryJSFunctionName == null || queryJSFunctionName.trim().length() < 1) {
            queryJSFunctionName = "gotoPage";
        }
        if (pageNoParamName == null || pageNoParamName.trim().length() < 1) {
            pageNoParamName = "pageno";
        }
        String gotoPage = "_" + queryJSFunctionName;
        StringBuffer html = new StringBuffer("\n");
        html.append("<script language=\"Javascript1.2\">\n").append("function ").append(gotoPage).append("(pageNo){  \n").append("   var curPage=1;  \n").append("   try{ curPage = document.getElementById(\"id_").append(pageNoParamName).append("\").value;  \n").append("        document.getElementById(\"id_").append(pageNoParamName).append("\").value = pageNo;  \n").append("        ").append(queryJSFunctionName).append("(pageNo); \n").append("        return true;  \n").append("   }catch(e){ \n").append("          alert('\u5c1a\u672a\u5b9a\u4e49\u67e5\u8be2\u65b9\u6cd5\uff1afunction ").append(queryJSFunctionName).append("()'); \n").append("          document.getElementById(\"id_").append(pageNoParamName).append("\").value = curPage;  \n").append("          return false;  \n").append("   }  \n").append("}\n").append("</script>\n").append("\n");
        html.append("<table class=\"multiPage\">\n").append("  <tr> \n").append("    <td width=\"15%\"></td>").append("    <td style=\"text-align:left;\">\u5171").append(this.getTotalPageCount()).append("\u9875").append("[").append(this.getStart()).append("..").append(this.getEnd()).append("/").append(this.getTotalSize()).append("]").append("</td>\n").append("    <td style=\"text-align:right;\">  \n");
        if (this.hasPreviousPage()) {
            html.append("[<a href='javascript:").append(gotoPage).append("(").append(this.getCurrentPageNo() - 1).append(")'>\u4e0a\u4e00\u9875</a>]   \n");
        }
        html.append("       \u7b2c<select name='").append(pageNoParamName).append("'  id='id_").append(pageNoParamName).append("' onChange='javascript:").append(gotoPage).append("(this.value)'>\n");
        String selected = "selected";
        int i = 1;
        while (i <= this.getTotalPageCount()) {
            selected = i == this.getCurrentPageNo() ? "selected" : "";
            html.append("      <option value='").append(i).append("' ").append(selected).append(">").append(i).append("</option>  \n");
            ++i;
        }
        if (this.getCurrentPageNo() > this.getTotalPageCount()) {
            html.append("      <option value='").append(this.getCurrentPageNo()).append("' selected>").append(this.getCurrentPageNo()).append("</option>  \n");
        }
        html.append("    </select>\u9875  \n");
        if (this.hasNextPage()) {
            html.append("    [<a href='javascript:").append(gotoPage).append("(").append(this.getCurrentPageNo() + 1).append(")'>\u4e0b\u4e00\u9875</a>]   \n");
        }
        html.append("    </td>\n").append("    <td width=\"15%\"></td>").append("  </tr>\n</table>");
        return html.toString();
    }
}

