/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.runtime.db.page;

import com.cntaiping.intserv.basic.runtime.db.DBUtil;
import com.cntaiping.intserv.basic.runtime.db.page.ListPage;
import com.cntaiping.intserv.basic.runtime.db.page.Page;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class PagedStatement
implements Serializable {
    private static final long serialVersionUID = 1084508619008394776L;
    private static Log log = LogFactory.getLog(PagedStatement.class);
    private static final int MAX_PAGE_SIZE = 9999;
    private String countSQL;
    private String querySQL;
    private int pageNo;
    private int pageSize;
    private int startIndex;
    private int totalCount;
    private List boundParams;
    private List dataList;
    private ListPage listPage;

    public PagedStatement(String sql) {
        this(sql, 1, 9999);
    }

    public PagedStatement(String sql, int pageNo) {
        this(sql, pageNo, 20);
    }

    public PagedStatement(String sql, int pageNo, int pageSize) {
        this.init(sql, pageNo, pageSize);
    }

    public PagedStatement(String sql_select, String sql_from_where, int pageNo) {
        this.init(sql_select, sql_from_where, pageNo, 20);
    }

    private void init(String sql, int pageNo, int pageSize) {
        log.info(sql);
        String sql_select = "select *  ";
        String sql_from_where = " from (" + sql + " )";
        this.init(sql_select, sql_from_where, pageNo, pageSize);
    }

    private void init(String sql_select, String sql_from_where, int pageNo, int pageSize) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.countSQL = "select count(*) " + sql_from_where;
        log.debug(this.countSQL);
        this.startIndex = Page.getStartOfAnyPage(pageNo, pageSize);
        this.querySQL = pageSize != 9999 ? new StringBuffer("select * from (select table_a.*,rownum as my_rownum from(").append(sql_select).append(" ").append(sql_from_where).append(") table_a where rownum<").append(this.startIndex + pageSize).append(") where my_rownum>=").append(this.startIndex).toString() : new StringBuffer("select * from (select table_a.*,rownum as my_rownum from(").append(sql_select).append(" ").append(sql_from_where).append(") table_a ").append(") where my_rownum>=").append(this.startIndex).toString();
        log.debug(this.querySQL);
        this.boundParams = Collections.synchronizedList(new LinkedList());
    }

    public void setObject(int index, Object obj) throws SQLException {
        BoundParam bp = new BoundParam(index, obj);
        this.boundParams.remove(bp);
        this.boundParams.add(bp);
    }

    public void setObject(int index, Object obj, int targetSqlType) throws SQLException {
        BoundParam bp = new BoundParam(index, obj, targetSqlType);
        this.boundParams.remove(bp);
        this.boundParams.add(bp);
    }

    public void setObject(int index, Object obj, int targetSqlType, int scale) throws SQLException {
        BoundParam bp = new BoundParam(index, obj, targetSqlType, scale);
        this.boundParams.remove(bp);
        this.boundParams.add(bp);
    }

    public void setString(int index, String str) throws SQLException {
        BoundParam bp = new BoundParam(index, str, 12);
        this.boundParams.remove(bp);
        this.boundParams.add(bp);
    }

    public void setTimestamp(int index, Timestamp timestamp) throws SQLException {
        BoundParam bp = new BoundParam(index, timestamp, 93);
        this.boundParams.remove(bp);
        this.boundParams.add(bp);
    }

    public void setInt(int index, int value) throws SQLException {
        BoundParam bp = new BoundParam(index, new Integer(value));
        this.boundParams.remove(bp);
        this.boundParams.add(bp);
    }

    public void setLong(int index, long value) throws SQLException {
        BoundParam bp = new BoundParam(index, new Long(value));
        this.boundParams.remove(bp);
        this.boundParams.add(bp);
    }

    public void setDouble(int index, double value) throws SQLException {
        BoundParam bp = new BoundParam(index, new Double(value));
        this.boundParams.remove(bp);
        this.boundParams.add(bp);
    }

    public void setBigDecimal(int index, BigDecimal bd) throws SQLException {
        BoundParam bp = new BoundParam(index, bd, 2);
        this.boundParams.remove(bp);
        this.boundParams.add(bp);
    }

    protected void setParams(PreparedStatement pst) throws SQLException {
        if (pst == null || this.boundParams == null || this.boundParams.size() == 0) {
            return;
        }
        for (BoundParam param : this.boundParams) {
            if (param == null) continue;
            if (param.sqlType == 1111) {
                pst.setObject(param.index, param.value);
                continue;
            }
            pst.setObject(param.index, param.value, param.sqlType, param.scale);
        }
    }

    protected void populate(ResultSet rs) throws SQLException {
        this.dataList = DBUtil.resultSetToList(rs);
    }

    protected void executeQueryUsingPreparedStatement() throws SQLException {
        ResultSet rs;
        PreparedStatement pst;
        Connection conn;
        block6: {
            conn = DBUtil.getConnection();
            pst = null;
            rs = null;
            pst = conn.prepareStatement(this.countSQL);
            this.setParams(pst);
            rs = pst.executeQuery();
            this.totalCount = rs.next() ? rs.getInt(1) : 0;
            rs.close();
            pst.close();
            if (this.totalCount >= 1) break block6;
            this.dataList = Collections.EMPTY_LIST;
            DBUtil.close(rs, pst, conn);
            return;
        }
        try {
            try {
                pst = conn.prepareStatement(this.querySQL);
                pst.setFetchSize(this.pageSize);
                this.setParams(pst);
                rs = pst.executeQuery();
                this.populate(rs);
                rs.close();
                rs = null;
                pst.close();
                pst = null;
            }
            catch (SQLException sqle) {
                log.error(sqle);
                sqle.printStackTrace();
                throw sqle;
            }
            catch (Exception e) {
                log.error(e);
                e.printStackTrace();
                throw new RuntimeException(e.toString());
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, pst, conn);
            throw throwable;
        }
        DBUtil.close(rs, pst, conn);
    }

    public ListPage executeQuery() throws SQLException {
        this.executeQueryUsingPreparedStatement();
        this.listPage = new ListPage(this.dataList, this.startIndex, this.totalCount, this.pageSize);
        return this.listPage;
    }

    public ListPage getListPage() throws SQLException {
        return this.listPage;
    }

    private static class BoundParam {
        int index;
        Object value;
        int sqlType;
        int scale;

        public BoundParam(int index, Object value) {
            this(index, value, 1111);
        }

        public BoundParam(int index, Object value, int sqlType) {
            this(index, value, sqlType, 0);
        }

        public BoundParam(int index, Object value, int sqlType, int scale) {
            this.index = index;
            this.value = value;
            this.sqlType = sqlType;
            this.scale = scale;
        }

        public boolean equals(Object obj) {
            if (obj != null && this.getClass().isInstance(obj)) {
                BoundParam bp = (BoundParam)obj;
                if (this.index == bp.index) {
                    return true;
                }
            }
            return false;
        }
    }
}

