/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.runtime.file;

import com.cntaiping.intserv.basic.runtime.Property;
import com.cntaiping.intserv.basic.runtime.db.DBUtil;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class FileUtil {
    private static Log log = LogFactory.getLog(FileUtil.class);
    private static String PATH_ROOT = null;

    static {
        try {
            PATH_ROOT = Property.getProperty(0, "FILE_PATH_ROOT", "none");
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    public static String writeFile(InputStream in, String fileName, String fileCate) throws Exception {
        String filePath = FileUtil.newHashPath(fileCate);
        FileUtil.writeFile(in, fileName, fileCate, filePath);
        return filePath;
    }

    public static void writeFile(InputStream in, String fileName, String fileCate, String filePath) throws Exception {
        FileUtil.mkdirs(String.valueOf(fileCate) + "/" + filePath);
        File file = new File(PATH_ROOT, String.valueOf(fileCate) + "/" + filePath + fileName);
        FileOutputStream out = new FileOutputStream(file);
        log.info("write file:" + fileCate + "/" + filePath + fileName);
        try {
            FileUtil.rw(in, out);
        }
        finally {
            FileUtil.close(null, out);
        }
    }

    public static void readFile(OutputStream out, String fileName, String fileCate, String filePath) throws IOException {
        FileUtil.readFile(out, String.valueOf(fileCate) + "/" + filePath + fileName);
    }

    public static void readFile(OutputStream out, String fullName) throws IOException {
        File file = new File(PATH_ROOT, fullName);
        FileInputStream in = new FileInputStream(file);
        log.info("read file:" + fullName);
        try {
            FileUtil.rw(in, out);
        }
        finally {
            FileUtil.close(in, null);
        }
    }

    public static InputStream readFile(String fullName) throws IOException {
        File file = new File(PATH_ROOT, fullName);
        FileInputStream in = new FileInputStream(file);
        log.info("read file:" + fullName);
        return in;
    }

    public static boolean removeFile(String fileName, String fileCate, String filePath) throws FileNotFoundException {
        return FileUtil.removeFile(String.valueOf(fileCate) + "/" + filePath + fileName);
    }

    public static boolean removeFile(String fullName) throws FileNotFoundException {
        File file = new File(PATH_ROOT, fullName);
        log.info("remove file:" + fullName);
        if (file.exists() && file.isFile()) {
            return file.delete();
        }
        return true;
    }

    public static boolean existFile(String fullName) throws FileNotFoundException {
        File file = new File(PATH_ROOT, fullName);
        log.info("check file:" + fullName);
        return file.exists() && file.isFile();
    }

    public static String newHashPath(String fileCate) throws Exception {
        String path = "";
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            conn = DBUtil.getConnection();
            pst = conn.prepareStatement("select to_char(sysdate,'YYYY/MM/DD/') from dual");
            rs = pst.executeQuery();
            if (rs.next()) {
                path = rs.getString(1);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, pst, conn);
            throw throwable;
        }
        DBUtil.close(rs, pst, conn);
        return path;
    }

    public static void mkdirs(String filePath) throws Exception {
        File path = new File(PATH_ROOT, filePath);
        if (!(path.exists() && path.isDirectory() || path.mkdirs())) {
            throw new Exception("cannot make dirs:" + filePath);
        }
    }

    public static void close(InputStream in, OutputStream out) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e) {
            log.error(e);
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    public static void rw(InputStream in, OutputStream out) throws IOException {
        int size;
        int accu = 0;
        byte[] buff = new byte[15360];
        while ((size = in.read(buff)) > 0) {
            out.write(buff, 0, size);
            if ((accu += size) < 15360) continue;
            out.flush();
            accu = 0;
        }
        if (accu > 0) {
            out.flush();
        }
    }
}

