/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.runtime.file;

import com.caucho.hessian.client.HessianProxyFactory;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.cntaiping.intserv.basic.runtime.Property;
import com.cntaiping.intserv.basic.runtime.file.FileUtil;
import com.cntaiping.intserv.basic.runtime.file.remote.FileUtilInterface;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class RFileUtil {
    private static Log log = LogFactory.getLog(RFileUtil.class);

    public static String writeFile(InputStream in, String fileName, String fileCate) throws Exception {
        String filePath = FileUtil.newHashPath(fileCate);
        RFileUtil.writeFile(in, fileName, fileCate, filePath);
        return filePath;
    }

    public static void writeFile(InputStream in, String fileName, String fileCate, String filePath) throws Exception {
        log.info("write file:" + fileCate + "/" + filePath + fileName);
        FileUtilInterface util = RFileUtil.createUtil();
        util.writeFile(fileName, fileCate, filePath, in);
    }

    public static void readFile(OutputStream out, String fileName, String fileCate, String filePath) throws Exception {
        RFileUtil.readFile(out, String.valueOf(fileCate) + "/" + filePath + fileName);
    }

    public static void readFile(OutputStream out, String fullName) throws Exception {
        InputStream in = null;
        HttpURLConnection conn = null;
        OutputStream hos = null;
        HessianOutput hout = null;
        InputStream his = null;
        HessianInput hin = null;
        log.info("read file:" + fullName);
        try {
            conn = RFileUtil.getConnection();
            hos = conn.getOutputStream();
            hout = new HessianOutput(hos);
            hout.call("readFile", (Object[])new String[]{fullName});
            hos.flush();
            his = conn.getInputStream();
            hin = new HessianInput(his);
            hin.readType();
            hin.completeValueReply();
            hin.readType();
            hin.completeValueReply();
            hin.readType();
            hin.completeValueReply();
            in = hin.readInputStream();
            FileUtil.rw(in, out);
        }
        catch (Throwable throwable) {
            try {
                hin.close();
                hout.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            FileUtil.close(in, null);
            FileUtil.close(his, hos);
            try {
                conn.disconnect();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            throw throwable;
        }
        try {
            hin.close();
            hout.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        FileUtil.close(in, null);
        FileUtil.close(his, hos);
        try {
            conn.disconnect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean removeFile(String fileName, String fileCate, String filePath) throws Exception {
        FileUtilInterface util = RFileUtil.createUtil();
        return util.removeFile(String.valueOf(fileCate) + "/" + filePath + fileName);
    }

    public static boolean removeFile(String fullName) throws Exception {
        FileUtilInterface util = RFileUtil.createUtil();
        return util.removeFile(fullName);
    }

    public static boolean existFile(String fullName) throws Exception {
        FileUtilInterface util = RFileUtil.createUtil();
        return util.existFile(fullName);
    }

    public static String grantFile(String fileName, String fileCate, String filePath, String authMode, String authDura, int plantId, String userId) throws Exception {
        FileUtilInterface util = RFileUtil.createUtil();
        return util.grantFile(fileName, fileCate, filePath, null, null, authMode, authDura, plantId, userId);
    }

    public static String grantFile(String fileName, String fileCate, String filePath, String showName, String showType, String authMode, String authDura, int plantId, String userId) throws Exception {
        FileUtilInterface util = RFileUtil.createUtil();
        return util.grantFile(fileName, fileCate, filePath, showName, showType, authMode, authDura, plantId, userId);
    }

    private static FileUtilInterface createUtil() throws Exception {
        String urlBase = Property.getProperty(0, "HESSIAN_URLBASE_FILE");
        HessianProxyFactory factory = new HessianProxyFactory();
        factory.setChunkedSize(8192);
        FileUtilInterface util = (FileUtilInterface)factory.create(FileUtilInterface.class, String.valueOf(urlBase) + "com.cntaiping.intserv.basic.runtime.file.remote.FileUtilServlet");
        return util;
    }

    private static HttpURLConnection getConnection() throws Exception {
        String urlBase = Property.getProperty(0, "HESSIAN_URLBASE_FILE");
        URL url = new URL(String.valueOf(urlBase) + "com.cntaiping.intserv.basic.runtime.file.remote.FileUtilServlet");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("content-type", "x-application/hessian");
        conn.setChunkedStreamingMode(8192);
        conn.setDoOutput(true);
        return conn;
    }
}

