/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.runtime.plant;

import com.cntaiping.intserv.basic.remote.RemoteFactory;
import com.cntaiping.intserv.basic.runtime.plant.ISPlant;
import com.cntaiping.intserv.basic.runtime.plant.PlantAccess;
import java.util.HashMap;

public class PlantAccessClient {
    private static HashMap<String, ISPlant> plantList = new HashMap();

    public static ISPlant getPlantModel(int plantId) throws Exception {
        if (plantList.containsKey("" + plantId)) {
            return plantList.get("" + plantId);
        }
        ISPlant plant = PlantAccessClient.createAccess().getPlantModel(plantId);
        if (plant != null) {
            plantList.put("" + plantId, plant);
        }
        return plant;
    }

    public static String getPlantUrlBase(int plantId) throws Exception {
        ISPlant plant = PlantAccessClient.getPlantModel(plantId);
        if (plant == null) {
            return null;
        }
        return plant.getUrlBase();
    }

    public static String getPlantUrlBaseCross(int plantId) throws Exception {
        ISPlant plant = PlantAccessClient.getPlantModel(plantId);
        if (plant == null) {
            return null;
        }
        return plant.getUrlBaseCross();
    }

    public static void clearCach() {
        plantList.clear();
    }

    public static int getOnlineLimit(int plantId, String serverAddr, String serverPort) throws Exception {
        return PlantAccessClient.createAccess().getOnlineLimit(plantId, serverAddr, serverPort);
    }

    public static void saveOnlineCount(int plantId, String serverAddr, String serverPort, int onlineCount) throws Exception {
        PlantAccessClient.createAccess().saveOnlineCount(plantId, serverAddr, serverPort, onlineCount);
    }

    public static int getPageLimit(int plantId, String serverAddr, String serverPort) throws Exception {
        return PlantAccessClient.createAccess().getPageLimit(plantId, serverAddr, serverPort);
    }

    private static PlantAccess createAccess() throws Exception {
        RemoteFactory factory = new RemoteFactory("SSO");
        PlantAccess access = (PlantAccess)factory.create(PlantAccess.class, "com.cntaiping.intserv.basic.runtime.plant.PlantAccessServlet");
        return access;
    }
}

