/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTools {
    public static Timestamp toTimestamp(String sDate) {
        if (sDate == null || "".equals(sDate)) {
            return null;
        }
        return Timestamp.valueOf(String.valueOf(sDate) + " 00:00:00.000000000");
    }

    public static Timestamp toTimestampEnd(String sDate) {
        if (sDate == null || "".equals(sDate)) {
            return null;
        }
        return Timestamp.valueOf(String.valueOf(sDate) + " 23:59:59.999999999");
    }

    public static Date toDate(String sDate) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.parse(sDate);
    }

    public static Date toDate(int year, int month, int date, int hour, int min, int sec) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, date, hour, min, sec);
        return calendar.getTime();
    }

    public static Date toDate(int year, int month, int date) {
        return DateTools.toDate(year, month, date, 0, 0, 0);
    }

    public static String toString(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(date);
    }

    public static int getDateAttr(Date date, String type) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if ("YEAR".equals(type)) {
            return calendar.get(1);
        }
        if ("MONTH".equals(type)) {
            return calendar.get(2) + 1;
        }
        if ("DATE".equals(type)) {
            return calendar.get(5);
        }
        if ("HOUR".equals(type)) {
            return calendar.get(10);
        }
        if ("MIN".equals(type)) {
            return calendar.get(1);
        }
        if ("SEC".equals(type)) {
            return calendar.get(13);
        }
        return -1;
    }

    public static int getDateAttr(long date, String type) {
        return DateTools.getDateAttr(new Date(date), type);
    }

    public static String getChineseDate(Date date) {
        String sDate = DateTools.toString(date);
        if (sDate == null || "".equals(sDate)) {
            return sDate;
        }
        return String.valueOf(sDate.substring(0, 4)) + "\u5e74" + sDate.substring(5, 7) + "\u6708" + sDate.substring(8) + "\u65e5";
    }

    public static long dateBetween(Date date_fst, Date date_lst) {
        return (date_lst.getTime() - date_fst.getTime()) / 86400000L;
    }

    public static int monthBetween(Date date_fst, Date date_lst) {
        Calendar cld_fst = Calendar.getInstance();
        Calendar cld_lst = Calendar.getInstance();
        cld_fst.setTime(date_fst);
        cld_lst.setTime(date_lst);
        int nYear = cld_lst.get(1) - cld_fst.get(1);
        int nMonth = cld_lst.get(2) - cld_fst.get(2);
        int nDate = cld_lst.get(5) - cld_fst.get(5);
        return nYear * 12 + nMonth + (nDate >= 0 ? 0 : -1);
    }

    public static Date dateAdd(Date date, int interval) {
        Date rt = new Date();
        rt.setTime(date.getTime() + 86400000L * (long)interval);
        return rt;
    }

    public static Date monthAdd(Date date, int interval) {
        Calendar cld = Calendar.getInstance();
        cld.setTime(date);
        cld.add(2, interval);
        return cld.getTime();
    }

    public static String sMonthEnd(String sDate) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateTools.toDate(sDate));
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return DateTools.toString(calendar.getTime());
    }

    public static String trunc(String sDate, String type) {
        if ("YEAR".equals(type)) {
            return String.valueOf(sDate.substring(0, 4)) + "-01-01";
        }
        if ("MONTH".equals(type)) {
            return String.valueOf(sDate.substring(0, 7)) + "-01";
        }
        return sDate;
    }
}

