/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.util;

import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import java.io.PrintWriter;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XMLTools {
    private static Log log = LogFactory.getLog(XMLTools.class);

    public static Element getCopy(Element element, String name) {
        Element rt = (Element)element.clone();
        rt.setName(name);
        return rt;
    }

    public static Element Elementize(String xml, String name) {
        try {
            Document document = DocumentHelper.parseText((String)xml);
            Element rt = document.getRootElement();
            return XMLTools.getCopy(rt, name);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(xml);
            log.error(e.getMessage());
            return null;
        }
    }

    public static Element ElementRoot(String xml) {
        try {
            Document document = DocumentHelper.parseText((String)xml);
            return document.getRootElement();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String Stringize(Element element) {
        return XMLTools.Stringize(element, "", false);
    }

    public static String Stringize(Element element, String indent, boolean newlines) {
        try {
            return element.asXML();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Element create(String name, String value) {
        Element rt = DocumentHelper.createElement((String)name);
        if (value != null && !"".equals(value)) {
            rt.addText(value);
        }
        return rt;
    }

    public static void outPrint(Element element) {
        log.info(XMLTools.Stringize(element, "  ", true));
    }

    public static void errPrint(Element element) {
        log.error(XMLTools.Stringize(element, "  ", true));
    }

    public static void print(PrintWriter out, Element element) {
        out.print(XMLTools.Stringize(element, "", false));
    }

    public static void println(PrintWriter out, Element element) {
        out.println(XMLTools.Stringize(element, "  ", true));
    }
}

