/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.util.log;

import com.cntaiping.intserv.basic.util.log.Log;
import java.io.Serializable;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class LogCommImpl
implements Log,
Serializable {
    private static final long serialVersionUID = 7761294476488483395L;
    private String name;
    private transient Logger logger;
    private static HashMap hm = new HashMap();

    static {
        try {
            InitialContext ctx = new InitialContext();
            String file = (String)ctx.lookup("java:comp/env/log4jConfigFile");
            if (file != null && !"".equals(file)) {
                System.out.println("log4jConfigFile:" + file);
                LogCommImpl.configure(file);
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public LogCommImpl(String name) {
        this.name = name;
    }

    public LogCommImpl(Class clazz) {
        this.name = clazz.getName();
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger((String)this.name);
        }
        return this.logger;
    }

    private Logger getLogger2(String name2) {
        Logger logger2;
        if (name2 == null || "".equals(name2)) {
            return null;
        }
        if (!hm.containsKey(name2)) {
            logger2 = Logger.getLogger((String)(String.valueOf(name2) + "." + this.name));
            hm.put(name2, logger2);
        } else {
            logger2 = (Logger)hm.get(name2);
        }
        return logger2;
    }

    @Override
    public void debug(Object message) {
        this.getLogger().debug(message);
    }

    @Override
    public void debug(Object message, Throwable arg1) {
        this.getLogger().debug(message, arg1);
    }

    @Override
    public void debug(Object message, String name2) {
        this.getLogger().debug(message);
        Logger logger2 = this.getLogger2(name2);
        if (logger2 != null) {
            logger2.debug(message);
        }
    }

    @Override
    public void info(Object message) {
        this.getLogger().info(message);
    }

    @Override
    public void info(Object message, Throwable arg1) {
        this.getLogger().info(message, arg1);
    }

    @Override
    public void info(Object message, String name2) {
        this.getLogger().info(message);
        Logger logger2 = this.getLogger2(name2);
        if (logger2 != null) {
            logger2.info(message);
        }
    }

    @Override
    public void warn(Object message) {
        this.getLogger().warn(message);
    }

    @Override
    public void warn(Object message, Throwable arg1) {
        this.getLogger().warn(message, arg1);
    }

    @Override
    public void warn(Object message, String name2) {
        this.getLogger().warn(message);
        Logger logger2 = this.getLogger2(name2);
        if (logger2 != null) {
            logger2.warn(message);
        }
    }

    @Override
    public void error(Object message) {
        this.getLogger().error(message);
    }

    @Override
    public void error(Object message, Throwable arg1) {
        this.getLogger().error(message, arg1);
    }

    @Override
    public void error(Object message, String name2) {
        this.getLogger().error(message);
        Logger logger2 = this.getLogger2(name2);
        if (logger2 != null) {
            logger2.error(message);
        }
    }

    @Override
    public void fatal(Object message) {
        this.getLogger().fatal(message);
    }

    @Override
    public void fatal(Object message, Throwable arg1) {
        this.getLogger().fatal(message, arg1);
    }

    @Override
    public void fatal(Object message, String name2) {
        this.getLogger().fatal(message);
        Logger logger2 = this.getLogger2(name2);
        if (logger2 != null) {
            logger2.fatal(message);
        }
    }

    public static void configure(String file) {
        PropertyConfigurator.configure((String)file);
    }
}

