/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.util.log;

import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import com.cntaiping.intserv.basic.util.security.MsgDigest;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.MDC;

public class LogRequestFilter
implements Filter {
    private Log log = LogFactory.getLog(LogRequestFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            LogRequestFilter.putMDC(req);
            this.log.info("Request-URL=" + req.getRequestURL());
            chain.doFilter(request, response);
            this.log.info("Request-End.");
            MDC.clear();
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
    }

    private static void putMDC(HttpServletRequest request) {
        try {
            String log4jRequestID = request.getHeader("Log4j-Request-ID");
            String log4jSessionID = request.getHeader("Log4j-Session-ID");
            if (log4jRequestID != null) {
                MDC.put((String)"RequestID", (String)log4jRequestID);
                if (log4jSessionID != null) {
                    MDC.put((String)"SessionID", (String)log4jSessionID);
                }
            } else {
                String md5Key = MsgDigest.MD5encrypt(String.valueOf(System.currentTimeMillis()) + "," + Math.random());
                MDC.put((String)"RequestID", (String)md5Key);
                HttpSession session = request.getSession();
                if (session != null) {
                    md5Key = MsgDigest.MD5encrypt(session.getId());
                    MDC.put((String)"SessionID", (String)md5Key);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

