/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.util.report;

import com.cntaiping.intserv.basic.util.Tools;
import com.cntaiping.intserv.basic.util.XMLTools;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import jxl.Workbook;
import jxl.format.Border;
import jxl.format.CellFormat;
import jxl.format.VerticalAlignment;
import jxl.write.Alignment;
import jxl.write.BorderLineStyle;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.dom4j.Element;

public class JExcel {
    public static final int TYPE_BLANK = 0;
    public static final int TYPE_NUMBER = 1;
    public static final int TYPE_CHAR = 2;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_RIGHT = 3;
    public static WritableCellFormat fmtTitle;
    public static WritableCellFormat fmtCaption;
    public static WritableCellFormat fmtGrid;
    public static WritableCellFormat fmtFoot;
    public static WritableCellFormat fmtNumber;
    private int col_num;
    private String[] col_symbol;
    private String[] col_name;
    private int[] col_type;
    private int[] col_width;

    static {
        fmtNumber = new WritableCellFormat(NumberFormats.FLOAT);
    }

    public JExcel(int col_max) {
        this.col_symbol = new String[col_max];
        this.col_name = new String[col_max];
        this.col_type = new int[col_max];
        this.col_width = new int[col_max];
        this.col_num = 0;
    }

    public int addCol(String symbol, String name, int type, int width) {
        this.col_symbol[this.col_num] = symbol;
        this.col_name[this.col_num] = name;
        this.col_type[this.col_num] = type;
        this.col_width[this.col_num] = width;
        ++this.col_num;
        return this.col_num;
    }

    public int write_rs(ResultSet rs, WritableSheet sheet, int x0, int y0, int title) throws Exception {
        int k;
        int x = x0;
        int y = y0;
        JExcel.initFormat();
        if (title == 1) {
            k = 0;
            while (k < this.col_num) {
                sheet.addCell((WritableCell)new Label(y + k, x, this.col_name[k], (CellFormat)fmtCaption));
                ++k;
            }
            ++x;
        }
        while (rs.next()) {
            k = 0;
            while (k < this.col_num) {
                switch (this.col_type[k]) {
                    case 0: {
                        sheet.addCell((WritableCell)new Label(y + k, x, "", (CellFormat)fmtGrid));
                        break;
                    }
                    case 1: {
                        if (rs.getString(this.col_symbol[k]) == null || rs.getString(this.col_symbol[k]).equals("")) {
                            sheet.addCell((WritableCell)new Label(y + k, x, rs.getString(this.col_symbol[k]), (CellFormat)fmtGrid));
                            break;
                        }
                        sheet.addCell((WritableCell)new Number(y + k, x, Tools.toDouble(rs.getString(this.col_symbol[k])), (CellFormat)fmtGrid));
                        break;
                    }
                    case 2: {
                        sheet.addCell((WritableCell)new Label(y + k, x, rs.getString(this.col_symbol[k]), (CellFormat)fmtGrid));
                    }
                }
                ++k;
            }
            ++x;
        }
        k = 0;
        while (k < this.col_num) {
            if (this.col_width[k] > 0) {
                sheet.setColumnView(y + k, this.col_width[k]);
            }
            ++k;
        }
        return x - x0;
    }

    public int write_rs_fin(ResultSet rs, WritableSheet sheet, int x0, int y0, int title) throws Exception {
        int k;
        int x = x0;
        int y = y0;
        JExcel.initFormat();
        if (title == 1) {
            k = 0;
            while (k < this.col_num) {
                sheet.addCell((WritableCell)new Label(y + k, x, this.col_name[k], (CellFormat)fmtCaption));
                ++k;
            }
            ++x;
        }
        while (rs.next()) {
            k = 0;
            while (k < this.col_num) {
                switch (this.col_type[k]) {
                    case 0: {
                        sheet.addCell((WritableCell)new Label(y + k, x, "", (CellFormat)fmtGrid));
                        break;
                    }
                    case 1: {
                        if (rs.getString(this.col_symbol[k]) == null || rs.getString(this.col_symbol[k]).equals("")) {
                            sheet.addCell((WritableCell)new Label(y + k, x, rs.getString(this.col_symbol[k]), (CellFormat)fmtGrid));
                            break;
                        }
                        sheet.addCell((WritableCell)new Number(y + k, x, Tools.toDouble(rs.getString(this.col_symbol[k])), (CellFormat)fmtGrid));
                        break;
                    }
                    case 2: {
                        WritableFont font1 = new WritableFont(WritableFont.TIMES, 10);
                        fmtGrid = new WritableCellFormat(font1);
                        fmtGrid.setAlignment(jxl.format.Alignment.CENTRE);
                        fmtGrid.setVerticalAlignment(VerticalAlignment.CENTRE);
                        fmtGrid.setBorder(Border.ALL, jxl.format.BorderLineStyle.THIN);
                        fmtGrid.setWrap(true);
                        sheet.addCell((WritableCell)new Label(y + k, x, rs.getString(this.col_symbol[k]), (CellFormat)fmtGrid));
                    }
                }
                ++k;
            }
            ++x;
        }
        k = 0;
        while (k < this.col_num) {
            if (this.col_width[k] > 0) {
                sheet.setColumnView(y + k, this.col_width[k]);
            }
            ++k;
        }
        return x - x0;
    }

    public int write_rs(List list, WritableSheet sheet, int x0, int y0, int title) throws Exception {
        int k;
        int x = x0;
        int y = y0;
        JExcel.initFormat();
        if (title == 1) {
            k = 0;
            while (k < this.col_num) {
                sheet.addCell((WritableCell)new Label(y + k, x, this.col_name[k], (CellFormat)fmtCaption));
                ++k;
            }
            ++x;
        }
        int i = 0;
        while (i < list.size()) {
            String[] str = (String[])list.get(i);
            k = 0;
            while (k < this.col_num) {
                switch (this.col_type[k]) {
                    case 0: {
                        sheet.addCell((WritableCell)new Label(y + k, x, "", (CellFormat)fmtGrid));
                        break;
                    }
                    case 1: {
                        sheet.addCell((WritableCell)new Number(y + k, x, Tools.toDouble(str[k]), (CellFormat)fmtGrid));
                        break;
                    }
                    case 2: {
                        sheet.addCell((WritableCell)new Label(y + k, x, str[k], (CellFormat)fmtGrid));
                    }
                }
                ++k;
            }
            ++x;
            ++i;
        }
        k = 0;
        while (k < this.col_num) {
            if (this.col_width[k] > 0) {
                sheet.setColumnView(y + k, this.col_width[k]);
            }
            ++k;
        }
        return x - x0;
    }

    public int write_xml(List list, String node, WritableSheet sheet, int x0, int y0, int title) throws Exception {
        int k;
        int x = x0;
        int y = y0;
        JExcel.initFormat();
        if (title == 1) {
            k = 0;
            while (k < this.col_num) {
                sheet.addCell((WritableCell)new Label(y + k, x, this.col_name[k], (CellFormat)fmtCaption));
                ++k;
            }
            ++x;
        }
        int i = 0;
        while (i < list.size()) {
            Element item = XMLTools.getCopy((Element)list.get(i), node);
            k = 0;
            while (k < this.col_num) {
                String val = item.selectSingleNode(this.col_symbol[k]).getText();
                switch (this.col_type[k]) {
                    case 0: {
                        sheet.addCell((WritableCell)new Label(y + k, x, "", (CellFormat)fmtGrid));
                        break;
                    }
                    case 1: {
                        sheet.addCell((WritableCell)new Number(y + k, x, Double.parseDouble(val), (CellFormat)fmtGrid));
                        break;
                    }
                    case 2: {
                        sheet.addCell((WritableCell)new Label(y + k, x, val, (CellFormat)fmtGrid));
                    }
                }
                ++k;
            }
            ++x;
            ++i;
        }
        k = 0;
        while (k < this.col_num) {
            if (this.col_width[k] > 0) {
                sheet.setColumnView(y + k, this.col_width[k]);
            }
            ++k;
        }
        return x - x0;
    }

    public static WritableWorkbook getBook(OutputStream out) {
        try {
            WritableWorkbook book = Workbook.createWorkbook((OutputStream)out);
            return book;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static WritableSheet getSheet(WritableWorkbook book, String name, int index) {
        try {
            WritableSheet sheet = book.createSheet(name, index);
            return sheet;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void mergeCell(WritableSheet sheet, WritableCellFormat fmt, int x1, int y1, int x2, int y2, String text) throws Exception {
        if (y1 != y2 || x1 != x2) {
            sheet.mergeCells(y1, x1, y2, x2);
        }
        if (fmt == null) {
            sheet.addCell((WritableCell)new Label(y1, x1, text));
        } else {
            sheet.addCell((WritableCell)new Label(y1, x1, text, (CellFormat)fmt));
        }
    }

    public static void mergeCell(WritableSheet sheet, WritableCellFormat fmt, int x1, int y1, int x2, int y2, double val) throws Exception {
        if (y1 != y2 || x1 != x2) {
            sheet.mergeCells(y1, x1, y2, x2);
        }
        if (fmt == null) {
            sheet.addCell((WritableCell)new Number(y1, x1, val));
        } else {
            sheet.addCell((WritableCell)new Number(y1, x1, val, (CellFormat)fmt));
        }
    }

    public static void initFormat() throws Exception {
        WritableFont font = new WritableFont(WritableFont.TIMES);
        font.setPointSize(10);
        fmtCaption = new WritableCellFormat(font);
        fmtCaption.setBorder(jxl.write.Border.ALL, BorderLineStyle.THIN);
        fmtCaption.setAlignment(Alignment.CENTRE);
        fmtGrid = new WritableCellFormat(font);
        fmtGrid.setBorder(jxl.write.Border.ALL, BorderLineStyle.THIN);
        font = new WritableFont(WritableFont.TIMES);
        font.setPointSize(10);
        font.setBoldStyle(WritableFont.BOLD);
        fmtFoot = new WritableCellFormat(font);
        fmtTitle = new WritableCellFormat(font);
        fmtTitle.setAlignment(Alignment.CENTRE);
    }

    public static String getCurDate(String format) {
        return new SimpleDateFormat(format).format(new Date());
    }
}

