/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.util.report;

import com.cntaiping.intserv.basic.util.exception.AppException;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class PdfUtil {
    private static Log log = LogFactory.getLog(PdfUtil.class);

    public static void mergePdfFile(File[] srcFiles, File dstFile, boolean delFlag) throws AppException {
        try {
            FileOutputStream outStream = new FileOutputStream(dstFile);
            Document doc = new Document();
            PdfCopy pdfCopy = new PdfCopy(doc, (OutputStream)outStream);
            doc.open();
            PdfReader pdfReader = null;
            PdfImportedPage impPage = null;
            int page = srcFiles.length;
            int i = 0;
            while (i < page) {
                FileInputStream fis = new FileInputStream(srcFiles[i]);
                pdfReader = new PdfReader((InputStream)fis);
                int pageCount = pdfReader.getNumberOfPages();
                int j = 1;
                while (j <= pageCount) {
                    pdfCopy.newPage();
                    impPage = pdfCopy.getImportedPage(pdfReader, j);
                    pdfCopy.addPage(impPage);
                    ++j;
                }
                pdfCopy.freeReader(pdfReader);
                pdfCopy.flush();
                fis.close();
                pdfReader.close();
                if (delFlag && srcFiles[i].exists()) {
                    srcFiles[i].delete();
                }
                ++i;
            }
            pdfCopy.close();
            doc.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AppException("\u751f\u6210PDF\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    public static void downloadPdfFile(File srcFile, HttpServletResponse response, boolean delFlag) throws AppException {
        if (!srcFile.exists()) {
            throw new AppException("\u5bfc\u51fapdf\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        try {
            block16: {
                response.setContentType("application/pdf");
                String filename = new String(srcFile.getName().getBytes("GBK"), "ISO8859_1").trim();
                response.setHeader("Content-Disposition", "attachment;filename=" + filename);
                ServletOutputStream out = response.getOutputStream();
                FileInputStream in = new FileInputStream(srcFile);
                try {
                    try {
                        byte[] buffer = new byte[4096];
                        int len = 0;
                        while ((len = ((InputStream)in).read(buffer)) != -1) {
                            out.write(buffer, 0, len);
                        }
                        out.flush();
                    }
                    catch (Exception e) {
                        log.info("\u7528\u6237\u53d6\u6d88\u4e86\u4e0b\u8f7d");
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                        if (out != null) {
                            out.close();
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    if (out != null) {
                        out.close();
                    }
                    throw throwable;
                }
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.close();
                }
            }
            if (delFlag && srcFile.exists()) {
                srcFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AppException("\u5bfc\u51faPDF\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public static void mergeAndDownloadPdfFile(File[] srcPdfFile, File dstPdfFile, HttpServletResponse response, boolean delFlag) throws AppException {
        try {
            PdfUtil.mergePdfFile(srcPdfFile, dstPdfFile, delFlag);
            PdfUtil.downloadPdfFile(dstPdfFile, response, delFlag);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AppException("\u64cd\u4f5cpdf\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
        }
    }
}

