/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.util.security;

import java.io.ByteArrayOutputStream;
import java.net.URLDecoder;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.servlet.http.HttpServletRequest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RSAUtil {
    public static final String RSA_PRIKEY = "RSA_PRIKEY";

    public static Map generateKeyPair() {
        HashMap<String, Object> rsKey = new HashMap<String, Object>();
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA", (Provider)new BouncyCastleProvider());
            int KEY_SIZE = 1024;
            keyPairGen.initialize(1024, new SecureRandom());
            KeyPair keyPair = keyPairGen.generateKeyPair();
            rsKey.put("pubkey", RSAUtil.getPubKey(keyPair.getPublic()));
            rsKey.put("prikey", keyPair.getPrivate());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rsKey;
    }

    public static String generateKeyPair(HttpServletRequest request) {
        String pubkeyStr = null;
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA", (Provider)new BouncyCastleProvider());
            int KEY_SIZE = 1024;
            keyPairGen.initialize(1024, new SecureRandom());
            KeyPair keyPair = keyPairGen.generateKeyPair();
            request.getSession().setAttribute("privateKey", (Object)keyPair.getPrivate());
            pubkeyStr = RSAUtil.getPubKey(keyPair.getPublic());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pubkeyStr;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static String decrypt(HttpServletRequest request, String pass) throws Exception {
        PrivateKey pk = (PrivateKey)request.getSession().getAttribute(RSA_PRIKEY);
        return RSAUtil.decryptDeal(pk, pass);
    }

    public static String decrypt(PrivateKey pk, String pass) throws Exception {
        return RSAUtil.decryptDeal(pk, pass);
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        int i = 0;
        while (i < length) {
            int pos = i * 2;
            d[i] = (byte)(RSAUtil.charToByte(hexChars[pos]) << 4 | RSAUtil.charToByte(hexChars[pos + 1]));
            ++i;
        }
        return d;
    }

    private static String decryptDeal(PrivateKey pk, String pass) throws Exception {
        String rsPass = "";
        byte[] en_result = RSAUtil.hexStringToBytes(pass);
        byte[] de_result = null;
        try {
            de_result = RSAUtil.decrypt(pk, en_result);
        }
        catch (Exception e) {
            System.out.println("session\u8fc7\u671f,\u79c1\u94a5\u5931\u6548!");
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(new String(de_result));
        rsPass = sb.reverse().toString();
        try {
            rsPass = URLDecoder.decode(rsPass, "UTF-8");
        }
        catch (IllegalArgumentException e) {
            System.out.println("\u9875\u9762\u65e0\u5237\u65b0,\u79c1\u94a5\u5931\u6548!");
            return "";
        }
        return rsPass;
    }

    private static String getPubKey(PublicKey pubkey) {
        String pubkeyS = null;
        try {
            pubkeyS = "" + pubkey;
            pubkeyS = pubkeyS.substring(pubkeyS.lastIndexOf("modulus: ") + 9, pubkeyS.indexOf("public exponent"));
            pubkeyS = pubkeyS.trim();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pubkeyS;
    }

    public static byte[] encrypt(PublicKey pk, byte[] data) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance("RSA", (Provider)new BouncyCastleProvider());
            cipher.init(1, pk);
            int blockSize = cipher.getBlockSize();
            int outputSize = cipher.getOutputSize(data.length);
            int leavedSize = data.length % blockSize;
            int blocksSize = leavedSize != 0 ? data.length / blockSize + 1 : data.length / blockSize;
            byte[] raw = new byte[outputSize * blocksSize];
            int i = 0;
            while (data.length - i * blockSize > 0) {
                if (data.length - i * blockSize > blockSize) {
                    cipher.doFinal(data, i * blockSize, blockSize, raw, i * outputSize);
                } else {
                    cipher.doFinal(data, i * blockSize, data.length - i * blockSize, raw, i * outputSize);
                }
                ++i;
            }
            return raw;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private static byte[] decrypt(PrivateKey pk, byte[] raw) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance("RSA", (Provider)new BouncyCastleProvider());
            cipher.init(2, pk);
            int blockSize = cipher.getBlockSize();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(64);
            int j = 0;
            while (raw.length - j * blockSize > 0) {
                bout.write(cipher.doFinal(raw, j * blockSize, blockSize));
                ++j;
            }
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }
}

