/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.util.web;

import eu.bitwalker.useragentutils.DeviceType;
import eu.bitwalker.useragentutils.Manufacturer;
import eu.bitwalker.useragentutils.OperatingSystem;
import eu.bitwalker.useragentutils.UserAgent;
import javax.servlet.http.HttpServletRequest;

public class BrowserUser {
    private HttpServletRequest request = null;
    private int deviceType = -1;
    private String browserType = null;
    private UserAgent userAgent = null;

    public BrowserUser(HttpServletRequest request) {
        this.request = request;
    }

    public String getIpAddr() {
        return BrowserUser.getIpAddr(this.request);
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public int getDeviceType() {
        if (this.deviceType >= 0) {
            return this.deviceType;
        }
        int deviceType = 0;
        this.parseUserAgent();
        OperatingSystem os = this.userAgent.getOperatingSystem();
        DeviceType device = os.getDeviceType();
        Manufacturer manu = os.getManufacturer();
        if (device == DeviceType.TABLET) {
            deviceType = 11;
            if (manu == Manufacturer.APPLE) {
                deviceType = 1;
            } else if (manu == Manufacturer.GOOGLE) {
                deviceType = 3;
            }
        } else if (device == DeviceType.MOBILE) {
            deviceType = 12;
            if (manu == Manufacturer.APPLE) {
                deviceType = 2;
            } else if (manu == Manufacturer.GOOGLE) {
                deviceType = 4;
            }
        } else if (device == DeviceType.GAME_CONSOLE) {
            deviceType = 13;
        } else if (device == DeviceType.WEARABLE) {
            deviceType = 14;
        }
        this.deviceType = deviceType;
        return this.deviceType;
    }

    public int getDeviceType2() {
        int deviceType = this.getDeviceType();
        switch (deviceType) {
            case 1: 
            case 3: {
                return 11;
            }
            case 2: 
            case 4: {
                return 12;
            }
        }
        return deviceType;
    }

    public String getBrowserName() {
        if (this.browserType != null) {
            return this.browserType;
        }
        this.parseUserAgent();
        this.browserType = this.userAgent.getBrowser().getName();
        return this.browserType;
    }

    private void parseUserAgent() {
        if (this.userAgent == null) {
            this.userAgent = UserAgent.parseUserAgentString((String)this.request.getHeader("User-Agent"));
        }
    }
}

