/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.util.web;

import com.cntaiping.intserv.basic.runtime.Property;
import com.cntaiping.intserv.basic.runtime.plant.PlantAccessClient;
import com.cntaiping.intserv.basic.util.exception.AppException;
import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import com.cntaiping.intserv.basic.util.web.PageLimitThread;
import com.cntaiping.intserv.basic.util.web.ThisServer;
import java.io.Serializable;
import java.util.Date;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;

public class PageLimit {
    private static Log log = LogFactory.getLog(PageLimit.class);
    private static Cache passPageCache = null;
    private static Cache dealPageCache = null;
    private static int dealPageLimit = -1;
    private static int initPageLimit = -1;

    static {
        try {
            CacheManager cacheManager = CacheManager.getInstance();
            cacheManager.removeCache("intserv.basic.util.web.PagePassCache");
            cacheManager.removeCache("intserv.basic.util.web.PageLimitCache");
            CacheConfiguration config = new CacheConfiguration("intserv.basic.util.web.PagePassCache", 2000);
            config.setEternal(false);
            config.setTimeToIdleSeconds(10L);
            config.setTimeToLiveSeconds(10L);
            cacheManager.addCache(new Cache(config));
            passPageCache = cacheManager.getCache("intserv.basic.util.web.PagePassCache");
            passPageCache.removeAll();
            PageLimitThread passThread = new PageLimitThread(1);
            passThread.start();
            log.info("passPageCache start with 2000");
            String sPageLimit = Property.getProperty(0, "PAGE_LIMIT");
            if (sPageLimit != null && !"".equals(sPageLimit)) {
                initPageLimit = dealPageLimit = Integer.parseInt(sPageLimit);
                config = new CacheConfiguration("intserv.basic.util.web.PageLimitCache", dealPageLimit);
                config.setEternal(false);
                config.setTimeToIdleSeconds(10L);
                config.setTimeToLiveSeconds(10L);
                cacheManager.addCache(new Cache(config));
                dealPageCache = cacheManager.getCache("intserv.basic.util.web.PageLimitCache");
                dealPageCache.removeAll();
                PageLimit.resetPageLimit();
                PageLimitThread dealThread = new PageLimitThread(2);
                dealThread.start();
                log.info("dealPageCache start with " + dealPageLimit);
            }
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    protected static void resetPageLimit() {
        try {
            int cnt = PlantAccessClient.getPageLimit(ThisServer.getPlantId(), ThisServer.getServerAddr(), ThisServer.getServerPort());
            if (cnt >= 0 && cnt < initPageLimit && cnt != dealPageLimit) {
                log.info("page limit set to " + cnt);
                dealPageLimit = cnt;
            }
        }
        catch (Exception e) {
            log.error((Object)ThisServer.info(), e);
        }
    }

    public static void allowRun(String pageCode) throws AppException {
        if (dealPageCache == null) {
            return;
        }
        Element elem = dealPageCache.get((Serializable)((Object)pageCode));
        if (elem != null) {
            throw new AppException(9001, "\u91cd\u590d\u63d0\u4ea4\uff0c\u8bf7\u68c0\u67e5\u64cd\u4f5c\u3002");
        }
        if (dealPageCache.getSize() >= dealPageLimit) {
            try {
                Thread.sleep(350L);
            }
            catch (InterruptedException e) {
                log.error(e);
            }
            throw new AppException(9002, "\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5\u3002");
        }
        dealPageCache.put(new Element((Serializable)((Object)pageCode), (Serializable)new Date()));
    }

    public static void noRepeat(String pageCode) throws AppException {
        if (passPageCache == null) {
            return;
        }
        Element elem = passPageCache.get((Serializable)((Object)pageCode));
        if (elem != null) {
            throw new AppException(9001, "\u91cd\u590d\u63d0\u4ea4\uff0c\u8bf7\u68c0\u67e5\u64cd\u4f5c\u3002");
        }
        passPageCache.put(new Element((Serializable)((Object)pageCode), (Serializable)new Date()));
    }

    protected static int getCacheSize() {
        if (dealPageCache == null) {
            return -1;
        }
        dealPageCache.evictExpiredElements();
        return dealPageCache.getSize();
    }

    protected static void clearPassCache() {
        if (passPageCache != null) {
            passPageCache.evictExpiredElements();
        }
    }
}

