/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.util.web;

import com.cntaiping.intserv.basic.util.log.Log;
import com.cntaiping.intserv.basic.util.log.LogFactory;
import com.cntaiping.intserv.basic.util.web.PageLimit;

public class PageLimitThread
extends Thread {
    private static Log log = LogFactory.getLog(PageLimitThread.class);
    private int cacheType = 0;
    private long last = 0L;
    private long time = 0L;

    public PageLimitThread(int cacheType) {
        this.cacheType = cacheType;
    }

    @Override
    public void run() {
        if (this.cacheType == 1) {
            log.info("page pass started.");
            try {
                while (true) {
                    Thread.sleep(1700L);
                    PageLimit.clearPassCache();
                }
            }
            catch (InterruptedException e) {
                log.error(e);
                log.info("page pass stopped.");
            }
        } else if (this.cacheType == 2) {
            if (PageLimit.getCacheSize() < 0) {
                log.info("page limit monitor skipped.");
                return;
            }
            log.info("page limit started.");
            try {
                while (true) {
                    Thread.sleep(1300L);
                    int cnt = PageLimit.getCacheSize();
                    long now = System.currentTimeMillis();
                    if (cnt < 2 && now - this.last < 900000L) continue;
                    this.last = now;
                    if (now - this.time < 180000L) continue;
                    this.time = now;
                    PageLimit.resetPageLimit();
                }
            }
            catch (InterruptedException e) {
                log.error(e);
                log.info("page limit stopped.");
            }
        }
    }
}

