/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.util.web;

import com.cntaiping.intserv.basic.runtime.Property;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;

public class ThisServer {
    private static int plantId = -1;
    private static String serverAddr = null;
    private static String serverPort = null;

    static {
        ThisServer.getServerAddrPort();
    }

    public static int getPlantId() {
        if (plantId <= 0) {
            ThisServer.getServerAddrPort();
        }
        return plantId;
    }

    public static String getServerAddr() {
        if (serverAddr == null) {
            ThisServer.getServerAddrPort();
        }
        return serverAddr;
    }

    public static String getServerPort() {
        if (serverPort == null) {
            ThisServer.getServerAddrPort();
        }
        return serverPort;
    }

    public static String info() {
        return String.valueOf(plantId) + "," + serverAddr + "," + serverPort;
    }

    private static void getServerAddrPort() {
        try {
            plantId = Integer.parseInt(Property.getProperty(0, "INTSERV_PLANT_ID"));
            InitialContext ctx = new InitialContext();
            MBeanServer mBeanServer = (MBeanServer)ctx.lookup("java:comp/env/jmx/runtime");
            ObjectName objectName = new ObjectName("com.bea:Name=RuntimeService,Type=weblogic.management.mbeanservers.runtime.RuntimeServiceMBean");
            ObjectName runtime = (ObjectName)mBeanServer.getAttribute(objectName, "ServerRuntime");
            String listenPort = String.valueOf(mBeanServer.getAttribute(runtime, "ListenPort"));
            String listenAddr = (String)mBeanServer.getAttribute(runtime, "ListenAddress");
            String[] tempAddr = listenAddr.split("/");
            if (tempAddr.length == 1) {
                listenAddr = tempAddr[0];
            } else if (tempAddr[tempAddr.length - 1].trim().length() != 0) {
                listenAddr = tempAddr[tempAddr.length - 1];
            } else if (tempAddr.length > 2) {
                listenAddr = tempAddr[tempAddr.length - 2];
            }
            serverAddr = listenAddr;
            serverPort = listenPort;
        }
        catch (Exception e) {
            e.printStackTrace();
            serverAddr = "0";
            serverPort = "0";
        }
    }
}

