/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.util.web;

import java.security.MessageDigest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class TokenUtil {
    private static final String TRANSACTION_TOKEN_KEY = "com.cntaiping.intserv.basic.util.web.TokenUtil.TOKEN";
    private static String TOKEN_INVALID_MSG = "\u6821\u9a8c\u5931\u8d25\uff01\u53ef\u80fd\u539f\u56e0\uff1a\u5237\u65b0\u9875\u9762\u3001\u91cd\u590d\u63d0\u4ea4\u6216\u4f1a\u8bdd\u4e22\u5931\u3002\u8bf7\u91cd\u65b0\u767b\u5f55\u7cfb\u7edf\u3002";

    public static String newTokenInput(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String token = TokenUtil.createToken(request);
        if (token != null) {
            session.setAttribute(TRANSACTION_TOKEN_KEY, (Object)token);
        }
        return "<input type='hidden' name='com.cntaiping.intserv.basic.util.web.TokenUtil.TOKEN' value='" + token + "'>";
    }

    public static void assertTokenValid(HttpServletRequest request) throws IllegalStateException {
        if (!TokenUtil.isTokenValid(request, true)) {
            throw new IllegalStateException(TOKEN_INVALID_MSG);
        }
    }

    protected static String createToken(HttpServletRequest request) {
        HttpSession session = request.getSession();
        try {
            byte[] id = session.getId().getBytes();
            byte[] now = new Long(System.currentTimeMillis()).toString().getBytes();
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(id);
            md.update(now);
            return TokenUtil.toHex(md.digest());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static boolean isTokenValid(HttpServletRequest request) {
        return TokenUtil.isTokenValid(request, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isTokenValid(HttpServletRequest request, boolean reset) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        HttpSession httpSession = session;
        synchronized (httpSession) {
            String token;
            String saved;
            block8: {
                block7: {
                    saved = (String)session.getAttribute(TRANSACTION_TOKEN_KEY);
                    if (saved != null) break block7;
                    return false;
                }
                if (reset) {
                    session.removeAttribute(TRANSACTION_TOKEN_KEY);
                }
                if ((token = request.getParameter(TRANSACTION_TOKEN_KEY)) != null) break block8;
                return false;
            }
            return saved.equals(token);
        }
    }

    protected static void resetToken(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        session.removeAttribute(TRANSACTION_TOKEN_KEY);
    }

    private static String toHex(byte[] buffer) {
        StringBuffer sb = new StringBuffer();
        String s = null;
        int i = 0;
        while (i < buffer.length) {
            s = Integer.toHexString(buffer[i] & 0xFF);
            if (s.length() < 2) {
                sb.append('0');
            }
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }
}

