/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.intserv.basic.util.web;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;

public class VerifyImage {
    private static Random random = new Random();
    private int width = 60;
    private int height = 20;
    private int length = 4;
    private int mixed = 0;

    public String createImage(String pattern, OutputStream out) throws Exception {
        switch (pattern.charAt(0)) {
            case 'G': {
                this.width = 120;
                this.height = 40;
                break;
            }
            case 'C': {
                this.width = 80;
            }
        }
        if (pattern.length() > 1) {
            this.length = Integer.parseInt(pattern.substring(1, 2));
            this.width = this.width * this.length / 4;
            if (pattern.length() > 2 && "M".equals(pattern.substring(2, 3))) {
                this.mixed = 1;
            }
        }
        BufferedImage image = new BufferedImage(this.width, this.height, 4);
        Graphics2D g = image.createGraphics();
        this.drawBackground(g);
        String verifyCode = this.drawRandomString(g, pattern);
        g.dispose();
        ImageIO.write((RenderedImage)image, "JPEG", out);
        return verifyCode;
    }

    private Color getRandomColor(int fc, int bc) {
        if (fc > 255) {
            fc = 200;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    private void drawBackground(Graphics2D g) {
        g.setColor(this.getRandomColor(200, 250));
        g.fillRect(0, 0, this.width, this.height);
        int len = this.height / 4;
        int i = 0;
        while (i < 2 * this.width) {
            g.setColor(this.getRandomColor(160, 200));
            int x = random.nextInt(this.width);
            int y = random.nextInt(this.height);
            int dx = random.nextInt(2 * len) - len;
            int dy = random.nextInt(2 * len) - len;
            g.drawLine(x, y, x + dx, y + dy);
            ++i;
        }
    }

    private String drawRandomString(Graphics2D g, String pattern) throws Exception {
        int type = 0;
        if (pattern.startsWith("N")) {
            type = 1;
        } else if (pattern.startsWith("c")) {
            type = 2;
        } else if (pattern.startsWith("C")) {
            type = 3;
        } else if (pattern.startsWith("G")) {
            type = 4;
        }
        StringBuffer buff = new StringBuffer();
        String temp = "";
        int itmp = 0;
        int i = 0;
        while (i < this.length) {
            switch (this.mixed == 1 ? random.nextInt(type) : type - 1) {
                case 0: {
                    itmp = random.nextInt(10) + 48;
                    temp = String.valueOf((char)itmp);
                    break;
                }
                case 1: {
                    itmp = random.nextInt(26) + 97;
                    temp = String.valueOf((char)itmp);
                    break;
                }
                case 2: {
                    itmp = random.nextInt(26) + 65;
                    temp = String.valueOf((char)itmp);
                    break;
                }
                case 3: {
                    byte[] bytes = new byte[]{(byte)(176 + random.nextInt(72)), (byte)(161 + random.nextInt(94))};
                    temp = new String(bytes);
                }
            }
            if ("".equals(temp.trim())) {
                --i;
            } else {
                g.setColor(new Color(20 + random.nextInt(20), 20 + random.nextInt(20), 20 + random.nextInt(20)));
                g.setFont(new Font(type == 4 ? "\u5b8b\u4f53" : "Times New Roman", 0, 15 + this.height / 5));
                g.drawString(temp, (int)((double)(this.width / (this.length + 1)) * ((double)i + 0.5)), (int)((double)this.height * 0.8) - random.nextInt((int)((double)this.height * 0.2)));
                buff.append(temp);
            }
            ++i;
        }
        g.dispose();
        return buff.toString();
    }
}

