/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.data.jackson;

import cn.zhxu.data.Array;
import cn.zhxu.data.Mapper;
import cn.zhxu.data.TypeRef;
import cn.zhxu.data.jackson.JacksonArray;
import cn.zhxu.data.jackson.JacksonMap;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JacksonMapper
implements Mapper {
    private final ObjectMapper om;
    private final ObjectNode json;

    public JacksonMapper(ObjectMapper om, ObjectNode json) {
        this.om = om;
        this.json = json;
    }

    public int size() {
        return this.json.size();
    }

    public boolean isEmpty() {
        return this.json.size() == 0;
    }

    public Mapper getMapper(String key) {
        JsonNode subJson = this.json.get(key);
        if (subJson != null && subJson.isObject()) {
            return new JacksonMapper(this.om, (ObjectNode)subJson);
        }
        return null;
    }

    public Array getArray(String key) {
        JsonNode subJson = this.json.get(key);
        if (subJson != null && subJson.isArray()) {
            return new JacksonArray(this.om, (ArrayNode)subJson);
        }
        return null;
    }

    public boolean getBool(String key) {
        JsonNode subJson = this.json.get(key);
        if (subJson != null) {
            return subJson.asBoolean(false);
        }
        return false;
    }

    public int getInt(String key) {
        JsonNode subJson = this.json.get(key);
        if (subJson != null) {
            return subJson.asInt(0);
        }
        return 0;
    }

    public long getLong(String key) {
        JsonNode subJson = this.json.get(key);
        if (subJson != null) {
            return subJson.asLong(0L);
        }
        return 0L;
    }

    public float getFloat(String key) {
        JsonNode subJson = this.json.get(key);
        if (subJson != null && subJson.isNumber()) {
            return subJson.floatValue();
        }
        if (subJson != null) {
            return (float)subJson.asDouble(0.0);
        }
        return 0.0f;
    }

    public double getDouble(String key) {
        JsonNode subJson = this.json.get(key);
        if (subJson != null) {
            return subJson.asDouble(0.0);
        }
        return 0.0;
    }

    public String getString(String key) {
        JsonNode subJson = this.json.get(key);
        if (subJson == null || subJson.isNull()) {
            return null;
        }
        return subJson.asText();
    }

    public <T> T toBean(Class<T> type) {
        try {
            return (T)this.om.treeToValue((TreeNode)this.json, type);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T toBean(final Type type) {
        try {
            return (T)this.om.readValue(this.om.treeAsTokens((TreeNode)this.json), new TypeReference<T>(){

                public Type getType() {
                    return type;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T toBean(TypeRef<T> type) {
        return this.toBean(type.getType());
    }

    public Map<String, Object> toMap() {
        return new JacksonMap(this.json);
    }

    public boolean has(String key) {
        return this.json.has(key);
    }

    public Set<String> keySet() {
        final Iterator it = this.json.fieldNames();
        return new AbstractSet<String>(){

            @Override
            public Iterator<String> iterator() {
                return it;
            }

            @Override
            public int size() {
                return JacksonMapper.this.json.size();
            }
        };
    }

    public String toString() {
        return this.json.toString();
    }
}

