/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.okhttps.internal;

import cn.zhxu.okhttps.AHttpTask;
import cn.zhxu.okhttps.Cancelable;
import cn.zhxu.okhttps.DownloadHelper;
import cn.zhxu.okhttps.HTTP;
import cn.zhxu.okhttps.HttpTask;
import cn.zhxu.okhttps.OkHttpsException;
import cn.zhxu.okhttps.Preprocessor;
import cn.zhxu.okhttps.SHttpTask;
import cn.zhxu.okhttps.TaskExecutor;
import cn.zhxu.okhttps.WHttpTask;
import cn.zhxu.okhttps.internal.SerialPreprocessor;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import okhttp3.MediaType;

public abstract class AbstractHttpClient
implements HTTP {
    final String baseUrl;
    final Map<String, String> mediaTypes;
    final TaskExecutor executor;
    final Preprocessor[] preprocessors;
    final List<TagTask> tagTasks;
    final int preprocTimeoutTimes;
    final Charset charset;
    final String bodyType;
    final DownloadHelper downloadHelper;

    public AbstractHttpClient(HTTP.Builder builder) {
        this.baseUrl = builder.baseUrl();
        this.mediaTypes = builder.getMediaTypes();
        this.executor = new TaskExecutor(builder, this.ioExecutor(builder));
        this.preprocessors = builder.preprocessors();
        this.preprocTimeoutTimes = builder.preprocTimeoutTimes();
        this.charset = builder.charset();
        this.bodyType = builder.bodyType();
        this.tagTasks = new LinkedList<TagTask>();
        this.downloadHelper = builder.downloadHelper();
    }

    public abstract Executor ioExecutor(HTTP.Builder var1);

    @Override
    public AHttpTask async(String url) {
        return new AHttpTask(this, this.urlPath(url, false));
    }

    @Override
    public SHttpTask sync(String url) {
        return new SHttpTask(this, this.urlPath(url, false));
    }

    @Override
    public WHttpTask webSocket(String url) {
        return new WHttpTask(this, this.urlPath(url, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cancel(String tag) {
        if (tag == null) {
            return 0;
        }
        int count = 0;
        List<TagTask> list = this.tagTasks;
        synchronized (list) {
            Iterator<TagTask> it = this.tagTasks.iterator();
            while (it.hasNext()) {
                TagTask tagCall = it.next();
                if (tagCall.tag.contains(tag)) {
                    if (tagCall.canceler.cancel()) {
                        ++count;
                    }
                    it.remove();
                    continue;
                }
                if (!tagCall.isExpired()) continue;
                it.remove();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAll() {
        this.doCancelAll();
        List<TagTask> list = this.tagTasks;
        synchronized (list) {
            this.tagTasks.clear();
        }
    }

    public abstract void doCancelAll();

    public int preprocTimeoutMillis() {
        return this.preprocTimeoutTimes * this.totalTimeoutMillis();
    }

    public abstract int totalTimeoutMillis();

    public int getTagTaskCount() {
        return this.tagTasks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TagTask addTagTask(String tag, Cancelable canceler, HttpTask<?> task) {
        TagTask tagTask = new TagTask(tag, canceler, task);
        List<TagTask> list = this.tagTasks;
        synchronized (list) {
            this.tagTasks.add(tagTask);
        }
        return tagTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTagTask(HttpTask<?> task) {
        List<TagTask> list = this.tagTasks;
        synchronized (list) {
            Iterator<TagTask> it = this.tagTasks.iterator();
            while (it.hasNext()) {
                TagTask tagCall = it.next();
                if (tagCall.task == task) {
                    it.remove();
                    break;
                }
                if (!tagCall.isExpired()) continue;
                it.remove();
            }
        }
    }

    public MediaType mediaType(String type) {
        String mediaType = this.mediaTypes.get(type);
        if (mediaType != null) {
            return MediaType.parse((String)mediaType);
        }
        if (type != null) {
            MediaType mType;
            if (type.indexOf(47) < 0) {
                type = "application/" + type;
            }
            if ((mType = MediaType.parse((String)type)) != null) {
                return mType;
            }
        }
        return MediaType.parse((String)"application/unknown");
    }

    @Override
    public TaskExecutor executor() {
        return this.executor;
    }

    public void preprocess(HttpTask<?> httpTask, Runnable request, boolean skipPreproc, boolean skipSerialPreproc) {
        int index;
        if (this.preprocessors.length == 0 || skipPreproc) {
            request.run();
            return;
        }
        if (skipSerialPreproc) {
            for (index = 0; index < this.preprocessors.length && this.preprocessors[index] instanceof SerialPreprocessor; ++index) {
            }
        }
        if (index < this.preprocessors.length) {
            RealPreChain chain = new RealPreChain(this.preprocessors, httpTask, request, index + 1, skipSerialPreproc);
            this.preprocessors[index].doProcess(chain);
        } else {
            request.run();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String urlPath(String urlPath, boolean websocket) {
        String fullUrl;
        if (urlPath == null) {
            if (this.baseUrl == null) throw new OkHttpsException("\u5728\u8bbe\u7f6e BaseUrl \u4e4b\u524d\uff0c\u60a8\u5fc5\u987b\u6307\u5b9a\u5177\u4f53\u8def\u5f84\u624d\u80fd\u53d1\u8d77\u8bf7\u6c42\uff01");
            fullUrl = this.baseUrl;
        } else {
            boolean isFullPath;
            boolean bl = isFullPath = (urlPath = urlPath.trim()).startsWith("https://") || urlPath.startsWith("http://") || urlPath.startsWith("wss://") || urlPath.startsWith("ws://");
            if (isFullPath) {
                fullUrl = urlPath;
            } else {
                if (this.baseUrl == null) throw new OkHttpsException("\u5728\u8bbe\u7f6e BaseUrl \u4e4b\u524d\uff0c\u60a8\u5fc5\u987b\u4f7f\u7528\u5168\u8def\u5f84URL\u53d1\u8d77\u8bf7\u6c42\uff0c\u5f53\u524dURL\u4e3a\uff1a'" + urlPath + "'");
                fullUrl = this.baseUrl + urlPath;
            }
        }
        if (websocket && fullUrl.startsWith("http")) {
            return fullUrl.replaceFirst("http", "ws");
        }
        if (websocket || !fullUrl.startsWith("ws")) return fullUrl;
        return fullUrl.replaceFirst("ws", "http");
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public Map<String, String> mediaTypes() {
        return this.mediaTypes;
    }

    public Preprocessor[] preprocessors() {
        return this.preprocessors;
    }

    public List<TagTask> tagTasks() {
        return this.tagTasks;
    }

    public int preprocTimeoutTimes() {
        return this.preprocTimeoutTimes;
    }

    public Charset charset() {
        return this.charset;
    }

    public String bodyType() {
        return this.bodyType;
    }

    public DownloadHelper downloadHelper() {
        return this.downloadHelper;
    }

    public class TagTask {
        String tag;
        Cancelable canceler;
        HttpTask<?> task;
        long createAt;

        TagTask(String tag, Cancelable canceler, HttpTask<?> task) {
            this.tag = tag;
            this.canceler = canceler;
            this.task = task;
            this.createAt = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.createAt > (long)AbstractHttpClient.this.preprocTimeoutMillis();
        }

        public void setTag(String tag) {
            this.tag = tag;
        }
    }

    class RealPreChain
    implements Preprocessor.PreChain {
        private int index;
        final Preprocessor[] preprocessors;
        final HttpTask<?> httpTask;
        final Runnable request;
        final boolean noSerialPreprocess;

        public RealPreChain(Preprocessor[] preprocessors, HttpTask<?> httpTask, Runnable request, int index, boolean noSerialPreprocess) {
            this.index = index;
            this.preprocessors = preprocessors;
            this.httpTask = httpTask;
            this.request = request;
            this.noSerialPreprocess = noSerialPreprocess;
        }

        @Override
        public HttpTask<?> getTask() {
            return this.httpTask;
        }

        @Override
        public HTTP getHttp() {
            return AbstractHttpClient.this;
        }

        @Override
        public void proceed() {
            if (this.noSerialPreprocess) {
                while (this.index < this.preprocessors.length && this.preprocessors[this.index] instanceof SerialPreprocessor) {
                    ++this.index;
                }
            } else {
                Preprocessor last = this.preprocessors[this.index - 1];
                if (last instanceof SerialPreprocessor) {
                    ((SerialPreprocessor)last).afterProcess();
                }
            }
            if (this.index < this.preprocessors.length) {
                this.preprocessors[this.index++].doProcess(this);
            } else {
                this.request.run();
            }
        }
    }
}

