/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.okhttps.internal;

import cn.zhxu.data.ArrayListMap;
import cn.zhxu.data.ListMap;
import cn.zhxu.okhttps.HttpResult;
import cn.zhxu.okhttps.HttpTask;
import cn.zhxu.okhttps.TaskExecutor;
import cn.zhxu.okhttps.internal.ResultBody;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import okhttp3.Headers;
import okhttp3.Response;

public class RealHttpResult
implements HttpResult {
    private HttpResult.State state;
    private Response response;
    private IOException error;
    private TaskExecutor taskExecutor;
    private final HttpTask<?> httpTask;
    private HttpResult.Body body;

    public RealHttpResult(HttpTask<?> httpTask, HttpResult.State state) {
        this.httpTask = httpTask;
        this.state = state;
    }

    public RealHttpResult(HttpTask<?> httpTask, Response response, TaskExecutor taskExecutor) {
        this(httpTask, taskExecutor);
        this.response(response);
    }

    public RealHttpResult(HttpTask<?> httpTask, TaskExecutor taskExecutor) {
        this.httpTask = httpTask;
        this.taskExecutor = taskExecutor;
    }

    public RealHttpResult(HttpTask<?> httpTask, HttpResult.State state, IOException error) {
        this.httpTask = httpTask;
        this.exception(state, error);
    }

    public void exception(HttpResult.State state, IOException error) {
        this.state = state;
        this.error = error;
    }

    public void response(Response response) {
        this.state = HttpResult.State.RESPONSED;
        this.response = response;
    }

    @Override
    public HttpResult.State getState() {
        return this.state;
    }

    @Override
    public int getStatus() {
        if (this.response != null) {
            return this.response.code();
        }
        return 0;
    }

    @Override
    public boolean isSuccessful() {
        if (this.response != null) {
            if (this.httpTask != null && this.httpTask.isWebsocket() && this.response.code() == 101) {
                return true;
            }
            return this.response.isSuccessful();
        }
        return false;
    }

    @Override
    public Headers getHeaders() {
        if (this.response != null) {
            return this.response.headers();
        }
        return null;
    }

    @Override
    public ListMap<String> allHeaders() {
        ArrayListMap map = new ArrayListMap();
        if (this.response != null) {
            Headers hs = this.response.headers();
            int size = hs.size();
            for (int i = 0; i < size; ++i) {
                map.put(hs.name(i), (Object)hs.value(i));
            }
        }
        return map;
    }

    @Override
    public List<String> getHeaders(String name) {
        if (this.response != null) {
            return this.response.headers(name);
        }
        return Collections.emptyList();
    }

    @Override
    public String getHeader(String name) {
        if (this.response != null) {
            return this.response.header(name);
        }
        return null;
    }

    @Override
    public long getContentLength() {
        String length = this.getHeader("Content-Length");
        if (length != null) {
            try {
                return Long.parseLong(length);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    @Override
    public synchronized HttpResult.Body getBody() {
        if (this.body == null && this.response != null) {
            this.body = new ResultBody(this, this.response, this.taskExecutor);
        }
        return this.body;
    }

    @Override
    public HttpTask<?> getTask() {
        return this.httpTask;
    }

    @Override
    public IOException getError() {
        return this.error;
    }

    public Response getResponse() {
        return this.response;
    }

    public String toString() {
        HttpResult.Body body = this.getBody();
        String str = "HttpResult [\n  state: " + (Object)((Object)this.state) + ",\n  status: " + this.getStatus() + ",\n  headers: " + this.getHeaders();
        if (body != null) {
            str = str + ",\n  contentType: " + body.getType();
        }
        return str + ",\n  error: " + this.error + "\n]";
    }

    @Override
    public HttpResult close() {
        if (this.response != null) {
            this.response.close();
        }
        return this;
    }
}

