/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.sms.net.rmi;

import com.cntaiping.sms.net.rmi.ISmsService;
import com.cntaiping.sms.net.rmi.TPSmsService;
import com.cntaiping.sms.net.utils.ConfigUtils;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;

public class SmsRmi {
    public static final String RMI_SERVICE_NAME = "smsService";
    private static ISmsService hImpl = null;

    public static void registryRmiService() {
        try {
            System.out.println("begin RMI Server ...");
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            hImpl = new TPSmsService();
            UnicastRemoteObject.exportObject((Remote)hImpl, ConfigUtils.getInt("export"));
            System.out.println("\u5c06\u5b9e\u4f8b\u6ce8\u518c\u5230\u4e13\u6709\u7684URL ,\u4f7f\u7528\u670d\u52a1\u7aef\u53e3" + ConfigUtils.getInt("export"));
            Registry register = LocateRegistry.createRegistry(ConfigUtils.getInt("port"));
            register.rebind(RMI_SERVICE_NAME, hImpl);
            System.out.println("waitubf RMI client invoke............");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unbindRmiService() {
        try {
            UnicastRemoteObject.unexportObject(hImpl, true);
            Registry reg = LocateRegistry.getRegistry(1099);
            reg.unbind(RMI_SERVICE_NAME);
            System.out.println(" RMI Server exit...");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        SmsRmi.registryRmiService();
    }
}

