/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.idm.clientTools;

import com.para.secure.builder.OAuthServiceBuilder;
import com.para.secure.client.model.UserInfo;
import com.para.secure.exceptions.OAuthApiException;
import com.para.secure.model.OAuth20Config;
import com.para.secure.model.Token;
import com.para.secure.oauth.IOAuth20Service;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthenticationTools {
    private static String getClientId;
    private static String getClientSecret;
    private static String getAuthorizeUrl;
    private static String getAccessTokenUrl;
    private static String getUserInfoUrl;
    private static String getRedirectUri;

    public void ssoAuth(JSONObject json, Map certMap, HttpServletRequest request, HttpServletResponse response, String ssoUrl) {
        try {
            getClientId = json.getString("appid");
            request.getSession().setAttribute("clientIdTpSSO", (Object)getClientId);
            getClientSecret = certMap.get("appKeyStoreAliasPwd").toString();
            getRedirectUri = json.getString("retUrl");
            request.getSession().setAttribute("redirectUriTpSSO", (Object)getRedirectUri);
            request.getSession().setAttribute("ssoUrlTpSSO", (Object)ssoUrl);
            getAuthorizeUrl = String.valueOf(ssoUrl) + "/profile/oauth2/authorize";
            getAccessTokenUrl = String.valueOf(ssoUrl) + "/profile/oauth2/accessToken";
            getUserInfoUrl = String.valueOf(ssoUrl) + "/profile/oauth2/profile";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OAuth20Config configInfo = new OAuth20Config(getClientId, getClientSecret, getRedirectUri, getAuthorizeUrl, getAccessTokenUrl);
        IOAuth20Service service = new OAuthServiceBuilder(configInfo).build20Service();
        String redUrl = service.getAuthorizationUrl();
        System.out.println("\u8df3\u8f6c\u8ba4\u8bc1\u5730\u5740\uff1a" + redUrl);
        try {
            response.sendRedirect(redUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JSONObject userAcquisition(HttpServletRequest request, Map certMap) {
        String code = request.getParameter("code");
        if ("".equals(code) || code == null) {
            return null;
        }
        if ("".equals(getClientId) || getClientId == null) {
            getClientId = (String)request.getSession().getAttribute("clientIdTpSSO");
        }
        if ("".equals(getClientSecret) || getClientSecret == null) {
            getClientSecret = (String)certMap.get("appKeyStoreAliasPwd");
        }
        if ("".equals(getRedirectUri) || getRedirectUri == null) {
            getRedirectUri = (String)request.getSession().getAttribute("redirectUriTpSSO");
        }
        if ("".equals(getAuthorizeUrl) || getAuthorizeUrl == null) {
            getAuthorizeUrl = String.valueOf((String)request.getSession().getAttribute("ssoUrlTpSSO")) + "/profile/oauth2/authorize";
        }
        if ("".equals(getAccessTokenUrl) || getAccessTokenUrl == null) {
            getAccessTokenUrl = String.valueOf((String)request.getSession().getAttribute("ssoUrlTpSSO")) + "/profile/oauth2/accessToken";
        }
        if ("".equals(getUserInfoUrl) || getUserInfoUrl == null) {
            getUserInfoUrl = String.valueOf((String)request.getSession().getAttribute("ssoUrlTpSSO")) + "/profile/oauth2/profile";
        }
        OAuth20Config configInfo = new OAuth20Config(getClientId, getClientSecret, getRedirectUri, getAuthorizeUrl, getAccessTokenUrl);
        IOAuth20Service service = new OAuthServiceBuilder(configInfo).build20Service();
        Token accessToken = service.getAccessToken(code);
        UserInfo oauthUser = new UserInfo(accessToken);
        String loginMess1 = null;
        try {
            loginMess1 = oauthUser.requestUserInfo(getUserInfoUrl);
        }
        catch (OAuthApiException e) {
            e.printStackTrace();
        }
        System.out.println("user mess=" + loginMess1);
        if ("".equals(loginMess1) || loginMess1 == null) {
            try {
                return new JSONObject("{\"error\":[\"\u8ba4\u8bc1\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\u6216\u8005\u7528\u6237\u65e0\u8be5\u5e94\u7528\u7cfb\u7edf\u8d26\u53f7\uff01\"]}");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        JSONObject resSend = new JSONObject();
        try {
            JSONObject res = new JSONObject(loginMess1);
            Iterator iterator = res.keys();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                JSONArray resArr = new JSONArray();
                if ("userName".equalsIgnoreCase(key.toString())) {
                    resArr.put(res.get((String)key));
                    resSend.put("cn", (Object)resArr);
                    continue;
                }
                resArr.put(res.get((String)key));
                resSend.put((String)key, (Object)resArr);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        System.out.println("send user mess=" + resSend);
        return resSend;
    }

    public void ssoDistory(JSONObject json, Map certMap, HttpServletRequest request, HttpServletResponse response, String ssoUrlLogout) {
        try {
            response.sendRedirect(ssoUrlLogout);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AuthenticationTools at = new AuthenticationTools();
        System.out.println();
        try {
            new JSONObject("{\"error\":[\"\u8ba4\u8bc1\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u7528\u6237\u65e0\u8be5\u5e94\u7528\u7cfb\u7edf\u8d26\u53f7\u6216\u8005\u672a\u8ba4\u8bc1\u6210\u529f\uff01\"]}");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JSONObject resSend = new JSONObject();
        if (resSend == null) {
            System.out.println("\u4e3a\u7a7a");
        }
    }
}

