/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.builder;

import com.para.secure.builder.api.OAuthApi20;
import com.para.secure.utils.Preconditions;

public class OAuthApiBuilder {
    private String authorizeUrl;
    private String accessTokenUrl;

    public OAuthApiBuilder authorizeUrl(String authorizeUrl) {
        Preconditions.checkEmptyString(authorizeUrl, "Invalid OAuth authorizeUrl");
        this.authorizeUrl = authorizeUrl;
        return this;
    }

    public OAuthApiBuilder accessTokenUrl(String accessTokenUrl) {
        Preconditions.checkEmptyString(accessTokenUrl, "Invalid OAuth accessTokenUrl");
        this.accessTokenUrl = accessTokenUrl;
        return this;
    }

    public OAuthApi20 buildApi20() {
        Preconditions.checkEmptyString(this.authorizeUrl, "Invalid OAuth authorizeUrl");
        Preconditions.checkEmptyString(this.accessTokenUrl, "Invalid OAuth accessTokenUrl");
        return new OAuthApi20(this.authorizeUrl, this.accessTokenUrl);
    }
}

